/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo;

import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.IAuthResult;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.ITemplateRepoOpenedEventListener;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.UrlSecurityCleaner;
import org.mule.tooling.templatesrepo.urls.SearchInLibraryUrlBuilder;
import org.mule.tooling.templatesrepo.utils.StudioInfoUtils;
import org.mule.tooling.templatesrepo.views.LibraryDialog;
import org.mule.tooling.templatesrepo.views.TemplateLibraryDialog;
import org.mule.tooling.ui.authentication.AuthenticationActivator;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class TemplatesRepository {
    public static final String DEFAULT_LIBRARY_URL = "https://anypoint.mulesoft.com/exchange/#!/";
    private LibraryDialog libraryDialog;
    private SearchInLibraryUrlBuilder libraryUrlBuilder;
    private UrlSecurityCleaner urlSecurityCleaner = UrlSecurityCleaner.UrlSecurityCleanerBuilder.withDefaultExchangeDelimiters().build();
    private static final TemplatesRepository INSTANCE = new TemplatesRepository();

    public static TemplatesRepository getInstance() {
        return INSTANCE;
    }

    public void openDialogOn(String url, String perspective, int mode) {
        boolean blockOnOpen = true;
        this.openDialogOn(url, perspective, mode, blockOnOpen);
    }

    public void openDialogOn(String url, String perspective, int mode, boolean blockOnOpen) {
        if (this.libraryDialog == null || this.libraryDialog.getShell() == null || this.libraryDialog.getShell().isDisposed()) {
            if (mode == 0) {
                this.libraryDialog = new TemplateLibraryDialog(null, StudioInfoUtils.getStudioInfoString(perspective), url);
                this.libraryDialog.setShellStyle(mode | 0x40 | 0x80 | 0x20 | 0x400 | 0x10);
            } else {
                this.libraryDialog = new TemplateLibraryDialog(Display.getCurrent().getActiveShell(), StudioInfoUtils.getStudioInfoString(perspective), url);
            }
            this.libraryDialog.setBlockOnOpen(blockOnOpen);
            this.libraryDialog.open();
            this.notifyRepoOpened(url, perspective);
        } else {
            this.libraryDialog.getShell().setFocus();
        }
    }

    public void openDialogOn(String url, String perspective) {
        this.openDialogOn(url, perspective, -1);
    }

    public void openDialogOn(String url, String perspective, boolean blockOnOpen) {
        this.openDialogOn(url, perspective, -1, blockOnOpen);
    }

    private void notifyRepoOpened(final String url, String perspective) {
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new IEvent<ITemplateRepoOpenedEventListener>(){

            public EventType<ITemplateRepoOpenedEventListener> getAssociatedType() {
                return CoreEventTypes.ON_TEMPLATE_REPO_OPENED_EVENT;
            }

            public void dispatch(ITemplateRepoOpenedEventListener handler) {
                handler.onTemplateRepoOpened(url);
            }
        });
        String urlToTrack = this.urlSecurityCleaner.cleanUrl(url, new String[]{"state"});
        AnalyticsRecordsFactory.single((String)Events.OPEN_EXCHANGE, (String[])new String[]{"library-url", urlToTrack, "perspective", perspective}).track();
    }

    public void close() {
        if (this.libraryDialog != null) {
            this.libraryDialog.close();
            this.libraryDialog = null;
        }
    }

    public String getRepositoryUrl() {
        String url = PlatformUrls.getActiveExchangeUrl();
        this.libraryUrlBuilder = new SearchInLibraryUrlBuilder().addBuildUrl(url);
        AuthUser activeUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
        if (activeUser != null) {
            IAuthResult tokenValid = CoreUtils.getLoginManager().isTokenValid(activeUser);
            if (tokenValid.succeeded()) {
                if (activeUser != null && !activeUser.getToken().isEmpty() && ((Boolean)tokenValid.getResult()).booleanValue()) {
                    this.libraryUrlBuilder.addAccessToken(activeUser.getToken());
                }
            } else {
                AuthenticationActivator.showError((IAuthResult)tokenValid);
            }
        }
        return this.libraryUrlBuilder.build();
    }

    public String getRepositoryUrlWithSearchTerm(String searchTerm) {
        this.getRepositoryUrl();
        this.libraryUrlBuilder.addSearchTerm(searchTerm);
        return this.libraryUrlBuilder.build();
    }

    public String getRepositoryUrl(String id) {
        return MessageFormat.format("{0}/{1}", this.getRepositoryUrl(), id);
    }
}

