/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo;

import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.templatesrepo.TemplatesRepository;
import org.mule.tooling.ui.authentication.utils.IStudioLoginRequired;

public class OpenLibraryCommand
implements IStudioLoginRequired {
    private String perspective;
    private String searchTerm;
    private boolean blockOnOpen = true;

    public static OpenLibraryCommand search(String searchTerm) {
        return new OpenLibraryCommand(null, searchTerm);
    }

    private static OpenLibraryCommand create(String perspective, String searchTerm) {
        return new OpenLibraryCommand(perspective, searchTerm);
    }

    public OpenLibraryCommand blockOnOpen(boolean blockOnOpen) {
        this.blockOnOpen = blockOnOpen;
        return this;
    }

    public static OpenLibraryCommand create(String perspective) {
        return OpenLibraryCommand.create(perspective, null);
    }

    private OpenLibraryCommand(String perspective, String searchTerm) {
        this.perspective = perspective;
        this.searchTerm = searchTerm;
    }

    public void execute() {
        this.runRequiringLogin("Open Exchange");
    }

    public void onAfterSuccessfulLogin(AuthUser activeUser) {
        TemplatesRepository templatesRepository = TemplatesRepository.getInstance();
        templatesRepository.openDialogOn(templatesRepository.getRepositoryUrlWithSearchTerm(this.searchTerm), this.perspective, this.blockOnOpen);
    }

    public void onAfterFailedLogin() {
    }
}

