/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.store;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.SharedImages;
import net.jeeeyul.eclipse.themes.ui.hotswap.RewriteCustomTheme;
import net.jeeeyul.eclipse.themes.ui.internal.Debug;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PropertiesUtil;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.store.EPFGenerator;
import net.jeeeyul.swtend.SWTExtensions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class StoreClient
extends EditorPart {
    public static final String EDITOR_ID = StoreClient.class.getCanonicalName();
    private Browser browser;
    private Text urlField;
    private ToolItem backItem;
    private ToolItem forwardItem;
    private ToolItem homeItem;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private String getBootstrapURL() {
        if (Debug.useLocalStore()) {
            return "http://localhost:3000/";
        }
        return "http://themes.jeeeyul.net";
    }

    public void createPartControl(Composite parent) {
        try {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            composite.setLayout((Layout)layout);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            ToolBar toolBar = new ToolBar(composite, 0x800000);
            this.backItem = new ToolItem(toolBar, 8);
            this.backItem.setImage(SharedImages.getImage("icons/backward_nav.gif"));
            this.backItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StoreClient.this.browser.back();
                }
            });
            this.forwardItem = new ToolItem(toolBar, 8);
            this.forwardItem.setImage(SharedImages.getImage("icons/forward_nav.gif"));
            this.forwardItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StoreClient.this.browser.forward();
                }
            });
            new ToolItem(toolBar, 2);
            this.homeItem = new ToolItem(toolBar, 8);
            this.homeItem.setImage(SharedImages.getImage("icons/home_nav.gif"));
            this.homeItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StoreClient.this.browser.setUrl(StoreClient.this.getBootstrapURL());
                }
            });
            this.urlField = new Text(composite, 2056);
            this.urlField.setLayoutData((Object)new GridData(768));
            ToolBar rightToolBar = new ToolBar(composite, 0x800000);
            ToolItem openInExternalBrowser = new ToolItem(rightToolBar, 8);
            openInExternalBrowser.setImage(SharedImages.getImage("icons/external_browser.gif"));
            openInExternalBrowser.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (StoreClient.this.urlField.getText().length() > 0) {
                        Program.launch((String)StoreClient.this.urlField.getText().trim());
                    }
                }
            });
            this.browser = new Browser(composite, 0);
            GridData browserData = new GridData(1808);
            browserData.horizontalSpan = 3;
            this.browser.setLayoutData((Object)browserData);
            this.initializeBrowser(this.browser, false);
            this.installFunctions();
            this.browser.setUrl(this.getBootstrapURL());
        }
        catch (SWTError sWTError) {
            this.createBrowserHelpPage(parent);
        }
    }

    private void createBrowserHelpPage(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText("Could not create browser, Please read <a href=\"https://github.com/jeeeyul/eclipse-themes/wiki/Linux-Theme-Store-Problem\">Linux User Guide</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)event.text);
            }
        });
    }

    private void installFunctions() {
        new BrowserFunction(this.browser, "__install"){

            public Object function(Object[] arguments) {
                if (arguments.length == 1 && arguments[0] instanceof String) {
                    String soruce = (String)arguments[0];
                    StoreClient.this.installEPF(soruce);
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "__getCurrentEPF"){

            public Object function(Object[] args) {
                return new EPFGenerator().generate();
            }
        };
        new BrowserFunction(this.browser, "__updateURL"){

            public Object function(Object[] args) {
                if (args.length == 1 && args[0] instanceof String) {
                    StoreClient.this.urlField.setText((String)args[0]);
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "__openURL"){

            public Object function(Object[] args) {
                if (args.length == 1 && args[0] instanceof String) {
                    String url = (String)args[0];
                    Program.launch((String)url);
                }
                return null;
            }
        };
    }

    private void installEPF(String epfString) {
        try {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(epfString.getBytes("ISO-8859-1")));
            IJTPreset defaultPreset = JThemesCore.getDefault().getPresetManager().getDefaultPreset();
            properties = PropertiesUtil.merge(defaultPreset.getProperties(), properties);
            JThemePreferenceStore store = JThemesCore.getDefault().getPreferenceStore();
            for (Object keyObj : properties.keySet()) {
                String key = (String)keyObj;
                String value = properties.getProperty(key);
                if (key.equals("LAYOUT__TAB_HEIGHT")) {
                    int intValue = Integer.parseInt(value);
                    store.setValue(key, Math.max(intValue, SWTExtensions.INSTANCE.getMinimumToolBarHeight()));
                    continue;
                }
                store.setValue(key, value);
            }
            new RewriteCustomTheme(true).rewrite();
            MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
            IEclipseContext context = application.getContext();
            IThemeEngine engine = (IThemeEngine)context.get(IThemeEngine.class);
            if (engine.getActiveTheme() == null || !engine.getActiveTheme().getId().equals("net.jeeeyul.eclipse.themes.custom")) {
                engine.setTheme("net.jeeeyul.eclipse.themes.custom", true);
            }
            store.setValue("MEMENTO__LAST_CHOOSED_PRESET", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
        if (SWTExtensions.INSTANCE.isAlive((Widget)this.browser)) {
            this.browser.setFocus();
        }
    }

    private void initializeBrowser(final Browser browser, boolean closable) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Debug.println("Open");
                if (!event.required) {
                    return;
                }
                Shell shell = new Shell(browser.getDisplay(), 1264);
                shell.setImage(SharedImages.getImage("icons/store.png"));
                shell.setText("New Window");
                shell.setLayout((Layout)new FillLayout());
                Browser browser2 = new Browser((Composite)shell, 0);
                StoreClient.this.initializeBrowser(browser2, true);
                event.browser = browser2;
            }
        });
        if (!closable) {
            return;
        }
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Debug.println("hide");
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Debug.println("show");
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size == null) {
                    event.size = new Point(1024, 768);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(Math.min(size.x, 1027), Math.min(size.y, 768)));
                }
                if (!(event.addressBar || event.menuBar || event.statusBar)) {
                    boolean cfr_ignored_0 = event.toolBar;
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Debug.println("close");
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                browser.getShell().setText(event.title);
            }
        });
        browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Debug.println("dispose");
            }
        });
    }
}

