/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.preset.internal;

import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.JTPUtil;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.preference.preset.internal.PresetLabelProvider;
import net.jeeeyul.eclipse.themes.ui.shared.CollectionContentProvider;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class UserPresetDialog
extends Dialog {
    @Extension
    private SWTExtensions _sWTExtensions = SWTExtensions.INSTANCE;
    private Text presetNameField;
    private TableViewer presetViewer;
    @Accessors
    private String selectedPresetName;
    private Button newPresetButton;
    private Button existingPresetButton;
    private CLabel validationLabel;

    public UserPresetDialog(Shell parentShell) {
        super(parentShell);
        int _or = this._sWTExtensions.operator_or(16, 64);
        int _or_1 = this._sWTExtensions.operator_or(_or, 32);
        this.setShellStyle(_or_1);
    }

    public void create() {
        super.create();
        Shell _shell = this.getShell();
        _shell.setText("Save as preset");
    }

    protected Control createDialogArea(Composite parent) {
        Composite _xblockexpression = null;
        Procedure1 _function = it -> {
            boolean _isDisposed = this.getShell().isDisposed();
            if (_isDisposed) {
                return;
            }
            this.updateUIStates();
        };
        this._sWTExtensions.schedule(_function);
        Control _createDialogArea = super.createDialogArea(parent);
        Procedures.Procedure1 _function_1 = it -> {
            TableViewer _doubleArrow;
            Procedure1 _function_2 = it_1 -> {
                it_1.setText("Save as a new preset");
                it_1.setSelection(true);
                Listener _function_3 = it_2 -> this.updateUIStates();
                this._sWTExtensions.setOnSelection((Widget)it_1, _function_3);
            };
            this.newPresetButton = this._sWTExtensions.newRadioButton(it, _function_2);
            Procedure1 _function_3 = it_1 -> {
                Procedure1 _function_4 = it_2 -> {
                    it_2.horizontalIndent = 16;
                };
                it_1.setLayoutData((Object)this._sWTExtensions.FILL_HORIZONTAL(_function_4));
                it_1.setMessage("Enter a new preset name");
                Listener _function_5 = it_2 -> {
                    this.validate();
                    this.selectedPresetName = this.presetNameField.getText().trim();
                };
                this._sWTExtensions.setOnModified((Control)it_1, _function_5);
            };
            this.presetNameField = this._sWTExtensions.newTextField(it, _function_3);
            Procedure1 _function_4 = it_1 -> {
                it_1.setText("Save as an existing preset");
                Listener _function_5 = it_2 -> this.updateUIStates();
                this._sWTExtensions.setOnSelection((Widget)it_1, _function_5);
            };
            this.existingPresetButton = this._sWTExtensions.newRadioButton(it, _function_4);
            int _or = this._sWTExtensions.operator_or(65536, 2048);
            TableViewer _tableViewer = new TableViewer(it, _or);
            Procedures.Procedure1 _function_5 = it_1 -> {
                Control _control = it_1.getControl();
                Procedure1 _function_6 = it_2 -> {
                    it_2.horizontalIndent = 16;
                };
                _control.setLayoutData((Object)this._sWTExtensions.FILL_BOTH(_function_6));
                PresetLabelProvider _presetLabelProvider = new PresetLabelProvider();
                it_1.setLabelProvider((IBaseLabelProvider)_presetLabelProvider);
                CollectionContentProvider _collectionContentProvider = new CollectionContentProvider();
                it_1.setContentProvider((IContentProvider)_collectionContentProvider);
                it_1.setInput(JThemesCore.getDefault().getPresetManager().getUserCategory().getPresets());
                ISelectionChangedListener _function_7 = it_2 -> {
                    ISelection _selection = this.presetViewer.getSelection();
                    Object _firstElement = ((IStructuredSelection)_selection).getFirstElement();
                    IJTPreset selected = (IJTPreset)_firstElement;
                    String _name = null;
                    if (selected != null) {
                        _name = selected.getName();
                    }
                    this.selectedPresetName = _name;
                    this.validate();
                };
                it_1.addSelectionChangedListener(_function_7);
            };
            this.presetViewer = _doubleArrow = (TableViewer)ObjectExtensions.operator_doubleArrow((Object)_tableViewer, (Procedures.Procedure1)_function_5);
            Procedure1 _function_6 = it_1 -> it_1.setLayoutData((Object)this._sWTExtensions.FILL_HORIZONTAL());
            this.validationLabel = this._sWTExtensions.newCLabel(it, _function_6);
        };
        _xblockexpression = (Composite)ObjectExtensions.operator_doubleArrow((Object)((Composite)_createDialogArea), (Procedures.Procedure1)_function_1);
        return _xblockexpression;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = JThemesCore.getDefault().getDialogSettings().getSection(UserPresetDialog.class.getCanonicalName());
        if (settings == null) {
            settings = JThemesCore.getDefault().getDialogSettings().addNewSection(UserPresetDialog.class.getCanonicalName());
        }
        return settings;
    }

    private void updateUIStates() {
        this.presetNameField.setEnabled(this.newPresetButton.getSelection());
        Control _control = this.presetViewer.getControl();
        _control.setEnabled(this.existingPresetButton.getSelection());
        this.validate();
    }

    private void validate() {
        String error = null;
        boolean _selection = this.newPresetButton.getSelection();
        if (_selection) {
            IInputValidator nameValidator = JTPUtil.getPresetNameValidator();
            String name = this.presetNameField.getText().trim();
            error = nameValidator.isValid(name);
        } else {
            ISelection _selection_1 = this.presetViewer.getSelection();
            Object _firstElement = ((IStructuredSelection)_selection_1).getFirstElement();
            IJTPreset selected = (IJTPreset)_firstElement;
            if (selected == null) {
                error = "Choose a preset to overwrite.";
            }
        }
        Button okButton = this.getButton(0);
        if (error == null) {
            this.validationLabel.setText("");
            this.validationLabel.setImage(null);
        } else {
            this.validationLabel.setText(error);
            this.validationLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        }
        okButton.setEnabled(error == null);
    }

    protected Control createButtonBar(Composite parent) {
        Control _xblockexpression = null;
        Procedures.Procedure1 _function = it -> {
            Procedure1 _function_1 = it_1 -> {};
            this._sWTExtensions.newHorizontalSeparator(it, _function_1);
        };
        ObjectExtensions.operator_doubleArrow((Object)parent, (Procedures.Procedure1)_function);
        _xblockexpression = super.createButtonBar(parent);
        return _xblockexpression;
    }

    public static void main(String[] args) {
        new UserPresetDialog(null).open();
    }

    @Pure
    public String getSelectedPresetName() {
        return this.selectedPresetName;
    }

    public void setSelectedPresetName(String selectedPresetName) {
        this.selectedPresetName = selectedPresetName;
    }
}

