/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.preset.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.shared.PresetIconGenerator;
import org.eclipse.jface.resource.ImageDescriptor;

public class UserPreset
implements IJTPreset {
    private Properties properties = new Properties();
    private File file;
    private String name;
    private ImageDescriptor imageDescriptor;

    public static boolean isSafeName(String name) {
        Matcher matcher = Pattern.compile("[\\/:*?\"<>|]").matcher(name);
        return !matcher.find();
    }

    public UserPreset(File file) throws IOException {
        this.name = file.getName().substring(0, file.getName().length() - 4);
        this.file = file;
        FileInputStream is = new FileInputStream(file);
        this.properties.load(is);
        is.close();
    }

    public UserPreset(String name) {
        this.setName(name);
    }

    public void delete() {
        if (this.file.exists()) {
            this.file.delete();
        }
        JThemesCore.getDefault().getPresetManager().invalidateUserPreset();
    }

    @Override
    public String getId() {
        return "net.jeeeyul.eclipse.themes.user.preset." + this.getName();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            this.imageDescriptor = new PresetIconGenerator().generatedDescriptor(this);
        }
        return this.imageDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private File getPresetFolder() {
        return JThemesCore.getDefault().getPresetManager().getUserPresetFolder();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void save() throws IOException {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
        this.file = new File(this.getPresetFolder(), String.valueOf(this.getName()) + ".epf");
        FileOutputStream os = new FileOutputStream(this.file);
        this.properties.store(os, "Jeeeyul's Eclipse Themes Custom Preset File");
        os.close();
        JThemesCore.getDefault().getPresetManager().invalidateUserPreset();
    }

    public void setName(String newName) {
        if (!UserPreset.isSafeName(newName)) {
            throw new IllegalArgumentException("Name must not contains: \\/:*?\"<>|");
        }
        this.name = newName;
    }
}

