/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.preset.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.ApplyPresetAction;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.JTPUtil;
import net.jeeeyul.eclipse.themes.ui.preference.internal.JTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetManagerListener;
import net.jeeeyul.eclipse.themes.ui.preference.preset.internal.UserPreset;
import net.jeeeyul.swtend.SWTExtensions;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JTPresetPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IJTPresetManagerListener {
    private SWTExtensions $ = SWTExtensions.INSTANCE;
    public static final String ID = JTPresetPreferencePage.class.getCanonicalName();
    private TableViewer viewer;
    private Button deleteButton;
    private Button renameButton;
    private Button importButton;
    private Button exportButton;
    private Button activateButton;

    private void activate() {
        IJTPreset selected = (IJTPreset)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (selected == null) {
            return;
        }
        new ApplyPresetAction(selected).run();
        this.copySettingsIfAvailable(selected);
    }

    private void copySettingsIfAvailable(IJTPreset selected) {
        IPreferencePageContainer container = this.getContainer();
        if (!(container instanceof PreferenceDialog)) {
            return;
        }
        PreferenceManager manager = ((PreferenceDialog)container).getPreferenceManager();
        List elements = manager.getElements(1);
        IPreferenceNode node = (IPreferenceNode)IterableExtensions.findFirst((Iterable)elements, (Functions.Function1)new Functions.Function1<IPreferenceNode, Boolean>(){

            public Boolean apply(IPreferenceNode t) {
                return t.getId().equals(JTPreferencePage.ID);
            }
        });
        if (node == null || node.getPage() == null) {
            return;
        }
        JTPreferencePage page = (JTPreferencePage)node.getPage();
        JThemePreferenceStore copy = JThemesCore.getDefault().getPreferenceStore().getCopyWithContext(null);
        Properties properties = selected.getProperties();
        for (Object keyObj : properties.keySet()) {
            String key = (String)keyObj;
            String value = properties.getProperty(key);
            if (key.equals("LAYOUT__TAB_HEIGHT")) {
                int intValue = Integer.parseInt(value);
                copy.setValue(key, Math.max(intValue, SWTExtensions.INSTANCE.getMinimumToolBarHeight()));
                continue;
            }
            copy.setValue(key, value);
        }
        page.loadFrom(copy);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer(container, 67586);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                IJTPreset preset = (IJTPreset)element;
                Image image = preset.getImageDescriptor().createImage();
                JTPresetPreferencePage.this.$.shouldDisposeWith((Resource)image, (Widget)JTPresetPreferencePage.this.viewer.getControl());
                return image;
            }

            public String getText(Object element) {
                return ((IJTPreset)element).getName();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return JThemesCore.getDefault().getPresetManager().getUserCategory().getPresets().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setInput((Object)JThemesCore.getDefault().getPresetManager().getUserCategory());
        GridData viewerLayoutData = new GridData(4, 4, true, false);
        viewerLayoutData.grabExcessVerticalSpace = true;
        viewerLayoutData.widthHint = 200;
        viewerLayoutData.heightHint = 200;
        viewerLayoutData.verticalSpan = 5;
        this.viewer.getControl().setLayoutData((Object)viewerLayoutData);
        this.activateButton = new Button(container, 8);
        this.activateButton.setText("Apply");
        this.activateButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.activateButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JTPresetPreferencePage.this.activate();
            }
        });
        this.deleteButton = new Button(container, 8);
        this.deleteButton.setText("Delete");
        this.deleteButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.deleteButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JTPresetPreferencePage.this.deleteSelection();
            }
        });
        this.renameButton = new Button(container, 8);
        this.renameButton.setText("Rename");
        this.renameButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.renameButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UserPreset preset = (UserPreset)((IStructuredSelection)JTPresetPreferencePage.this.viewer.getSelection()).getFirstElement();
                if (preset != null) {
                    JTPresetPreferencePage.this.rename(preset);
                }
            }
        });
        this.importButton = new Button(container, 8);
        this.importButton.setText("Import...");
        this.importButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.importButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JTPresetPreferencePage.this.doImport();
            }
        });
        this.exportButton = new Button(container, 8);
        this.exportButton.setText("Export...");
        this.exportButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.exportButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JTPresetPreferencePage.this.doExport();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JTPresetPreferencePage.this.updateButtons();
            }
        });
        this.updateButtons();
        return container;
    }

    private void deleteSelection() {
        List<UserPreset> selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        boolean confirmed = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Jeeeyul's Eclipse Themes", (String)"Are you sure to remove selected use presets?");
        if (confirmed) {
            for (UserPreset each : selection) {
                each.delete();
            }
        }
    }

    public void dispose() {
        JThemesCore.getDefault().getPresetManager().removeListener(this);
        super.dispose();
    }

    private void doExport() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        UserPreset userPreset = this.getSelection().get(0);
        dialog.setFileName(String.valueOf(userPreset.getName()) + ".epf");
        dialog.setOverwrite(true);
        dialog.setFilterExtensions(new String[]{"*.epf"});
        dialog.setFilterNames(new String[]{"Eclipse Preference File"});
        String target = dialog.open();
        if (target != null) {
            try {
                FileOutputStream fos = new FileOutputStream(target);
                userPreset.getProperties().store(fos, "Jeeeyul's Eclipse Themes Preset");
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void doImport() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001002);
        dialog.setFilterExtensions(new String[]{"*.epf"});
        dialog.setFilterNames(new String[]{"Eclipse Preference File"});
        String firstFile = dialog.open();
        if (firstFile != null) {
            File dir = new File(firstFile).getParentFile();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String each = stringArray[n2];
                this.importEPF(new File(dir, each));
                ++n2;
            }
        }
    }

    private List<UserPreset> getSelection() {
        Object[] array;
        ArrayList<UserPreset> selection = new ArrayList<UserPreset>();
        Object[] objectArray = array = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object each = objectArray[n2];
            if (each instanceof UserPreset) {
                selection.add((UserPreset)each);
            }
            ++n2;
        }
        return selection;
    }

    private void importEPF(File file) {
        try {
            String name = file.getName().replaceFirst("[.][^.]+$", "");
            IInputValidator nameValidator = JTPUtil.getPresetNameValidator();
            String error = nameValidator.isValid(name);
            if (error != null) {
                String initialInput;
                int number = 2;
                while (nameValidator.isValid(initialInput = MessageFormat.format("{0}({1})", name, number)) != null) {
                }
                InputDialog nameDialog = new InputDialog(this.getShell(), "Import Preset", MessageFormat.format("{0} Enter a new preset name:", error), initialInput, nameValidator);
                if (nameDialog.open() != 0) {
                    return;
                }
                name = nameDialog.getValue().trim();
            }
            UserPreset newPreset = new UserPreset(name);
            FileInputStream fis = new FileInputStream(file);
            newPreset.getProperties().load(fis);
            fis.close();
            newPreset.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init(IWorkbench workbench) {
        JThemesCore.getDefault().getPresetManager().addListener(this);
    }

    private void rename(UserPreset preset) {
        InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), "New Preset", "Enter a new preset name:", null, JTPUtil.getPresetNameValidator());
        if (dialog.open() != 0) {
            return;
        }
        preset.setName(dialog.getValue().trim());
        try {
            preset.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateButtons() {
        List<UserPreset> selection = this.getSelection();
        this.activateButton.setEnabled(selection.size() == 1);
        this.deleteButton.setEnabled(selection.size() > 0);
        this.renameButton.setEnabled(selection.size() == 1);
        this.exportButton.setEnabled(selection.size() == 1);
        this.importButton.setEnabled(true);
    }

    @Override
    public void userPresetModified() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }
}

