/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.preset.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetCategory;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetManager;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetManagerListener;
import net.jeeeyul.eclipse.themes.ui.preference.preset.internal.ContributedPreset;
import net.jeeeyul.eclipse.themes.ui.preference.preset.internal.PresetCategoryImpl;
import net.jeeeyul.eclipse.themes.ui.preference.preset.internal.UserPreset;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class JTPresetManager
implements IJTPresetManager {
    private HashSet<IJTPresetManagerListener> listeners = new HashSet();
    private Map<String, IJTPresetCategory> categories = new HashMap<String, IJTPresetCategory>();
    private IJTPresetCategory defaultCategory = new PresetCategoryImpl("Default Presets", "net.jeeeyul.eclipse.themes.category.default");
    private IJTPresetCategory userCategory = new PresetCategoryImpl("User Presets", "net.jeeeyul.eclipse.themes.category.user");
    private boolean isLoaded = false;
    private boolean needToLoadUserCategory = true;

    public JTPresetManager() {
        this.categories.put(this.defaultCategory.getID(), this.defaultCategory);
        this.categories.put(this.userCategory.getID(), this.userCategory);
    }

    @Override
    public void addListener(IJTPresetManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public IJTPresetCategory getDefaultCategory() {
        if (!this.isLoaded) {
            this.loadPresetExtensions();
        }
        return this.defaultCategory;
    }

    @Override
    public IJTPreset getDefaultPreset() {
        if (!this.isLoaded) {
            this.loadPresetExtensions();
        }
        for (IJTPreset each : this.getDefaultCategory().getPresets()) {
            if (!"net.jeeeyul.eclipse.themes.preset.default".equals(each.getId())) continue;
            return each;
        }
        return null;
    }

    private Comparator<IJTPreset> getPresetComparator() {
        return new Comparator<IJTPreset>(){

            @Override
            public int compare(IJTPreset o1, IJTPreset o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        };
    }

    @Override
    public IJTPresetCategory getUserCategory() {
        if (this.needToLoadUserCategory) {
            this.loadUserPresets();
        }
        return this.userCategory;
    }

    @Override
    public File getUserPresetFolder() {
        IPath path = JThemesCore.getDefault().getStateLocation();
        File stateFolder = path.toFile();
        File presetFolder = new File(stateFolder, "user-presets");
        if (presetFolder.exists() && !presetFolder.isDirectory()) {
            presetFolder.delete();
        }
        if (!presetFolder.exists()) {
            presetFolder.mkdir();
        }
        return presetFolder;
    }

    @Override
    public void invalidateUserPreset() {
        if (this.userCategory.getPresets() != null) {
            this.userCategory.getPresets().clear();
            this.needToLoadUserCategory = true;
        }
        for (IJTPresetManagerListener each : this.listeners) {
            try {
                each.userPresetModified();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPresetExtensions() {
        IConfigurationElement each;
        IConfigurationElement[] elements;
        if (this.isLoaded) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("net.jeeeyul.eclipse.themes.preset");
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            each = iConfigurationElementArray[n2];
            if (each.getName().equals("preset-category")) {
                PresetCategoryImpl category = new PresetCategoryImpl(each);
                this.categories.put(category.getID(), category);
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            each = iConfigurationElementArray[n2];
            if (each.getName().equals("preset")) {
                ContributedPreset preset = new ContributedPreset(each);
                IJTPresetCategory category = this.categories.get(preset.getCategoryID());
                category.getPresets().add(preset);
            }
            ++n2;
        }
        this.isLoaded = true;
        for (IJTPresetCategory eachCategory : this.categories.values()) {
            Collections.sort(eachCategory.getPresets(), this.getPresetComparator());
        }
        IJTPreset defaultPreset = this.getDefaultPreset();
        if (defaultPreset != null) {
            this.defaultCategory.getPresets().remove(defaultPreset);
            this.defaultCategory.getPresets().add(0, defaultPreset);
        }
    }

    @Override
    public IJTPresetCategory getCategory(String id) {
        if (id.equals("net.jeeeyul.eclipse.themes.category.user")) {
            return this.getUserCategory();
        }
        if (!this.isLoaded) {
            this.loadPresetExtensions();
        }
        return this.categories.get(id);
    }

    private void loadUserPresets() {
        File[] files;
        File[] fileArray = files = this.getUserPresetFolder().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".epf");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File each = fileArray[n2];
            try {
                this.userCategory.getPresets().add(new UserPreset(each));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(this.userCategory.getPresets(), this.getPresetComparator());
        this.needToLoadUserCategory = false;
    }

    @Override
    public void removeListener(IJTPresetManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public IJTPresetCategory[] getCategories() {
        if (!this.isLoaded) {
            this.loadPresetExtensions();
        }
        if (this.needToLoadUserCategory) {
            this.loadUserPresets();
        }
        ArrayList<IJTPresetCategory> values = new ArrayList<IJTPresetCategory>(this.categories.values());
        Collections.sort(values, new Comparator<IJTPresetCategory>(){

            @Override
            public int compare(IJTPresetCategory o1, IJTPresetCategory o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        values.remove(this.userCategory);
        values.remove(this.defaultCategory);
        values.add(0, this.defaultCategory);
        values.add(0, this.userCategory);
        IJTPresetCategory[] result = values.toArray(new IJTPresetCategory[this.categories.size()]);
        return result;
    }
}

