/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.preset.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.shared.PresetIconGenerator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ContributedPreset
implements IJTPreset {
    public static final String EXTENSION_POINT = "net.jeeeyul.eclipse.themes.preset";
    public static final String ELEMENT_PRESET = "preset";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_EPF = "epf";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_CATEGORY = "category";
    private IConfigurationElement element;
    private Properties properties;
    private ImageDescriptor descriptor;
    private String categoryId;

    public ContributedPreset(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.descriptor == null) {
            String iconAttr = this.element.getAttribute(ATTR_ICON);
            if (iconAttr != null && !iconAttr.isEmpty()) {
                String contributor = this.element.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)contributor);
                this.descriptor = ImageDescriptor.createFromURL((URL)bundle.getResource(iconAttr));
            } else {
                this.descriptor = new PresetIconGenerator().generatedDescriptor(this);
            }
        }
        return this.descriptor;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    public String getCategoryID() {
        if (this.categoryId == null) {
            this.categoryId = this.element.getAttribute(ATTR_CATEGORY);
            if (this.categoryId == null) {
                this.categoryId = "net.jeeeyul.eclipse.themes.category.default";
            }
        }
        return this.categoryId;
    }

    protected void loadProperties() {
        this.properties = new Properties();
        try {
            String path = this.element.getAttribute(ATTR_EPF);
            String contributor = this.element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)contributor);
            URL resource = bundle.getResource(path);
            this.properties.load(resource.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.element.getAttribute(ATTR_NAME);
    }

    @Override
    public String getId() {
        return this.element.getAttribute(ATTR_ID);
    }
}

