/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import net.jeeeyul.eclipse.themes.SharedImages;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.AbstractJTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreperencePageHelper;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class UserCSSPage
extends AbstractJTPreferencePage {
    private SourceViewer viewer;
    private TextViewerUndoManager undoManager;
    private KeyStroke undoKey;
    private KeyStroke redoKey;
    private KeyStroke selectAllKey;

    public UserCSSPage() {
        try {
            this.setName("Custom CSS");
            this.setImage(SharedImages.getImage("icons/css.gif"));
            this.undoKey = KeyStroke.getInstance((String)"M1+z");
            KeyStroke _xifexpression = null;
            boolean _contains = System.getProperties().getProperty("os.name").contains("Mac");
            _xifexpression = _contains ? KeyStroke.getInstance((String)"M1+M2+z") : KeyStroke.getInstance((String)"M1+y");
            this.redoKey = _xifexpression;
            this.selectAllKey = KeyStroke.getInstance((String)"M1+a");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Control createContents(Composite parent, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        Procedure1 _function = it -> {
            TextViewerUndoManager _textViewerUndoManager;
            SourceViewer _sourceViewer;
            it.setLayout((Layout)swtExtensions.newGridLayout());
            Procedure1 _function_1 = it_1 -> {
                it_1.setImage(SharedImages.getImage("icons/warn_tsk.gif"));
                it_1.setText("Using this feature can cause side effects.");
            };
            swtExtensions.newCLabel(it, _function_1);
            int _or = swtExtensions.operator_or(512, 256);
            int _or_1 = swtExtensions.operator_or(_or, 2048);
            this.viewer = _sourceViewer = new SourceViewer(it, null, _or_1);
            Document _document = new Document();
            this.viewer.setDocument((IDocument)_document);
            SourceViewerConfiguration _sourceViewerConfiguration = new SourceViewerConfiguration();
            this.viewer.configure(_sourceViewerConfiguration);
            this.undoManager = _textViewerUndoManager = new TextViewerUndoManager(100);
            this.undoManager.connect((ITextViewer)this.viewer);
            this.viewer.setUndoManager((IUndoManager)this.undoManager);
            Control _control = this.viewer.getControl();
            Listener _function_2 = it_1 -> this.handleKeyDown(it_1);
            swtExtensions.setOnKeyDown(_control, _function_2);
            Control _control_1 = this.viewer.getControl();
            Procedure1 _function_3 = it_1 -> {
                it_1.heightHint = 200;
                it_1.widthHint = 200;
            };
            _control_1.setLayoutData((Object)swtExtensions.FILL_BOTH(_function_3));
        };
        return swtExtensions.newComposite(parent, _function);
    }

    private void handleKeyDown(Event e) {
        boolean _matches = this.matches(e, this.undoKey);
        if (_matches) {
            boolean _undoable = this.undoManager.undoable();
            if (_undoable) {
                this.undoManager.undo();
            }
        } else {
            boolean _matches_1 = this.matches(e, this.redoKey);
            if (_matches_1) {
                boolean _redoable = this.undoManager.redoable();
                if (_redoable) {
                    this.undoManager.redo();
                }
            } else {
                boolean _matches_2 = this.matches(e, this.selectAllKey);
                if (_matches_2) {
                    this.viewer.setSelectedRange(0, this.viewer.getDocument().getLength());
                }
            }
        }
    }

    @Override
    public void updatePreview(CTabFolder folder, JTabSettings renderSettings, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
    }

    @Override
    public void load(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        this.viewer.getDocument().set(store.getString("OTHERS__USER_CSS"));
        this.undoManager.reset();
    }

    @Override
    public void save(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        store.setValue("OTHERS__USER_CSS", this.viewer.getDocument().get());
    }

    @Override
    public void dispose(@Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        this.undoManager.disconnect();
    }

    private boolean matches(Event e, KeyStroke stroke) {
        return stroke.getModifierKeys() == e.stateMask && e.keyCode == stroke.getNaturalKey();
    }
}

