/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import net.jeeeyul.eclipse.themes.SharedImages;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.AbstractJTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.IPreferenceFilter;
import net.jeeeyul.eclipse.themes.ui.preference.internal.JTPUtil;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PartStackPage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PartStacksPage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreperencePageHelper;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Function1;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorPicker;
import net.jeeeyul.swtend.ui.ColorStop;
import net.jeeeyul.swtend.ui.Gradient;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ToolsPage
extends AbstractJTPreferencePage {
    public ToolsPage() {
        super("Tools");
        this.setImage(SharedImages.getImage("icons/config.png"));
    }

    @Override
    public Control createContents(Composite parent, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        Procedure1 _function = it -> {
            Procedure1 _function_1 = it_1 -> {};
            it.setLayout((Layout)swtExtensions.newGridLayout(_function_1));
            Procedure1 _function_2 = it_1 -> {
                it_1.setText("Batch Color Tasks");
                it_1.setLayout((Layout)swtExtensions.newGridLayout());
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_3 = it_2 -> {
                    it_2.setText("Re-write hue globally");
                    Listener _function_4 = it_3 -> this.rewriteHue(helper);
                    swtExtensions.setOnSelection((Widget)it_2, _function_4);
                };
                swtExtensions.newPushButton((Composite)it_1, _function_3);
            };
            swtExtensions.newGroup(it, _function_2);
            Procedure1 _function_3 = it_1 -> {
                it_1.setText("Part Stack Batch Task");
                it_1.setLayout((Layout)swtExtensions.newGridLayout());
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_4 = it_2 -> {
                    it_2.setText("Copy settings from Active to Inactive");
                    Listener _function_5 = it_3 -> this.copy("ACTIVE_PART_STACK", "INACTIVE_PART_STACK", swtExtensions, helper);
                    swtExtensions.setOnSelection((Widget)it_2, _function_5);
                };
                swtExtensions.newPushButton((Composite)it_1, _function_4);
                Procedure1 _function_5 = it_2 -> {
                    it_2.setText("Copy settings from Inactive to Active");
                    Listener _function_6 = it_3 -> this.copy("INACTIVE_PART_STACK", "ACTIVE_PART_STACK", swtExtensions, helper);
                    swtExtensions.setOnSelection((Widget)it_2, _function_6);
                };
                swtExtensions.newPushButton((Composite)it_1, _function_5);
            };
            swtExtensions.newGroup(it, _function_3);
        };
        return swtExtensions.newComposite(parent, _function);
    }

    private void rewriteHue(@Extension PreperencePageHelper helper) {
        boolean _equals;
        ColorPicker picker = new ColorPicker(null);
        HSB _hSB = new HSB(255, 0, 0);
        picker.setSelection(_hSB);
        int _open = picker.open();
        boolean bl = _equals = _open == 0;
        if (_equals) {
            JThemePreferenceStore copy = helper.createWorkingCopy();
            List<String> gradientKeys = JTPUtil.listPreferenceKeys(IPreferenceFilter.FILTER_PRESET.chain(IPreferenceFilter.GRADIENT_TYPE_FILTER));
            for (String each : gradientKeys) {
                Gradient grad = copy.getGradient(each);
                for (ColorStop eachStop : grad) {
                    eachStop.color.hue = picker.getSelection().hue;
                }
                copy.setValue(each, grad);
            }
            List<String> hsbKeys = JTPUtil.listPreferenceKeys(IPreferenceFilter.FILTER_PRESET.chain(IPreferenceFilter.HSB_TYPE_FILTER));
            for (String each_1 : hsbKeys) {
                HSB hsb = copy.getHSB(each_1);
                hsb.hue = picker.getSelection().hue;
                copy.setValue(each_1, hsb);
            }
            helper.loadFromWorkingCopy(copy);
        }
    }

    @Override
    public void updatePreview(CTabFolder folder, JTabSettings renderSettings, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
    }

    @Override
    public void load(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
    }

    @Override
    public void save(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
    }

    @Override
    public void dispose(@Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
    }

    private void copy(String from, String to, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        AbstractJTPreferencePage[] sibilings;
        PartStacksPage stacksPage = (PartStacksPage)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)helper.getAllPages())), PartStacksPage.class));
        AbstractJTPreferencePage[] _converted_sibilings = sibilings = stacksPage.getChildren();
        Functions.Function1 _function = it -> {
            String _context = it.getContext();
            return Objects.equal((Object)_context, (Object)from);
        };
        PartStackPage fromPage = (PartStackPage)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_sibilings)), PartStackPage.class), (Functions.Function1)_function);
        AbstractJTPreferencePage[] _converted_sibilings_1 = sibilings;
        Functions.Function1 _function_1 = it -> {
            String _context = it.getContext();
            return Objects.equal((Object)_context, (Object)to);
        };
        PartStackPage toPage = (PartStackPage)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_sibilings_1)), PartStackPage.class), (Functions.Function1)_function_1);
        PreferenceStore _preferenceStore = new PreferenceStore();
        JThemePreferenceStore fakeStore = new JThemePreferenceStore((IPersistentPreferenceStore)_preferenceStore);
        Function1 _function_2 = it -> it;
        fakeStore.setCustomKeyResolver((Function1<String, String>)_function_2);
        fromPage.save(fakeStore, swtExtensions, helper);
        toPage.load(fakeStore, swtExtensions, helper);
        helper.requestUpdatePreview();
    }
}

