/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorPicker;
import net.jeeeyul.swtend.ui.ColorWell;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TextShadowEdit {
    private ColorWell colorWell;
    private Button noneButton;
    private Button belowButton;
    private Button upperButton;
    private Composite control;
    private Procedure1<TextShadowEdit> modifyHandler;

    public TextShadowEdit(Composite composite) {
        this.control = new Composite(composite, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.control.setLayout((Layout)layout);
        this.colorWell = new ColorWell(this.control, 0);
        this.noneButton = new Button(this.control, 16);
        this.noneButton.setText("None");
        this.belowButton = new Button(this.control, 16);
        this.belowButton.setText("Below");
        this.upperButton = new Button(this.control, 16);
        this.upperButton.setText("Upper");
        this.colorWell.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorPicker picker = new ColorPicker(TextShadowEdit.this.control.getShell());
                HSB original = TextShadowEdit.this.colorWell.getSelection();
                picker.setSelection(original);
                picker.setContinuosSelectionHandler((Procedure1)new Procedure1<HSB>(){

                    public void apply(HSB t) {
                        TextShadowEdit.this.colorWell.setSelection(t, true);
                    }
                });
                if (picker.open() == 0) {
                    TextShadowEdit.this.colorWell.setSelection(picker.getSelection(), true);
                } else {
                    TextShadowEdit.this.colorWell.setSelection(original, true);
                }
            }
        });
        Listener dispatchModify = new Listener(){

            public void handleEvent(Event event) {
                if (TextShadowEdit.this.modifyHandler != null) {
                    TextShadowEdit.this.modifyHandler.apply((Object)TextShadowEdit.this);
                }
            }
        };
        this.noneButton.addListener(13, dispatchModify);
        this.belowButton.addListener(13, dispatchModify);
        this.upperButton.addListener(13, dispatchModify);
        this.colorWell.addListener(24, dispatchModify);
    }

    public HSB getColor() {
        return this.colorWell.getSelection();
    }

    public Composite getControl() {
        return this.control;
    }

    public Procedure1<TextShadowEdit> getModifyHandler() {
        return this.modifyHandler;
    }

    public Point getShadowPosition() {
        if (this.noneButton.getSelection()) {
            return new Point(0, 0);
        }
        if (this.belowButton.getSelection()) {
            return new Point(0, 1);
        }
        return new Point(0, -1);
    }

    public void setColor(HSB color) {
        this.colorWell.setSelection(color, false);
    }

    public void setModifyHandler(Procedure1<TextShadowEdit> modifyHandler) {
        this.modifyHandler = modifyHandler;
    }

    public void setShadowPosition(Point point) {
        if (point.y < 0) {
            this.upperButton.setSelection(true);
            this.belowButton.setSelection(false);
            this.noneButton.setSelection(false);
        } else if (point.y > 0) {
            this.upperButton.setSelection(false);
            this.belowButton.setSelection(true);
            this.noneButton.setSelection(false);
        } else {
            this.upperButton.setSelection(false);
            this.belowButton.setSelection(false);
            this.noneButton.setSelection(true);
        }
    }
}

