/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jeeeyul.eclipse.themes.SharedImages;
import net.jeeeyul.eclipse.themes.css.EditorLineSupport;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.AbstractJTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.LineStyleEditor;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreferenceLink;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreperencePageHelper;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorWell;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TextEditorPage
extends AbstractJTPreferencePage {
    private static final String PREF_ID_COLOR_THEME = "com.github.eclipsecolortheme.preferences.ColorThemePreferencePage";
    private static final String PREF_ID_EDITBOX = "pm.eclipse.editbox.pref.default";
    private static final String PREF_ID_GENERAL_TEXT_EDITORS = "org.eclipse.ui.preferencePages.GeneralTextEditor";
    private SourceViewer preview;
    private LineStyleEditor underLineStyleEdit;
    private ColorWell underLineColorEdit;
    private ColorWell rulerColorEdit;
    private Composite previewWrap;
    private IVerticalRulerColumn annotationRulerColumn;
    private LineNumberRulerColumn lineNumberRulerColumn;
    private Color textEditorBackground;
    private Color textEditorForeground;
    private Color rulerColor;
    private Color lineNumberColor;

    public TextEditorPage() {
        super("Editor");
        this.setImage(SharedImages.getImage("icons/file.gif"));
    }

    @Override
    public Control createContents(Composite parent, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        Procedure1 _function = it -> {
            LineStyleEditor _doubleArrow;
            Procedure1 _function_1 = it_1 -> {
                it_1.numColumns = 2;
            };
            it.setLayout((Layout)swtExtensions.newGridLayout(_function_1));
            Procedure1 _function_2 = it_1 -> {
                SourceViewer _sourceViewer;
                LineNumberRulerColumn _lineNumberRulerColumn;
                Procedure1 _function_3 = it_2 -> {
                    it_2.horizontalSpan = 2;
                };
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL(_function_3));
                Procedure1 _function_4 = it_2 -> {
                    it_2.marginWidth = 0;
                    it_2.marginHeight = 0;
                };
                it_1.setLayout((Layout)swtExtensions.newGridLayout(_function_4));
                CompositeRuler ruler = new CompositeRuler(1);
                AnnotationRulerColumn _annotationRulerColumn = new AnnotationRulerColumn(12);
                this.annotationRulerColumn = _annotationRulerColumn;
                ruler.addDecorator(0, this.annotationRulerColumn);
                this.lineNumberRulerColumn = _lineNumberRulerColumn = new LineNumberRulerColumn();
                ruler.addDecorator(1, (IVerticalRulerColumn)this.lineNumberRulerColumn);
                this.preview = _sourceViewer = new SourceViewer(it_1, (IVerticalRuler)ruler, 512);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Jeeeyul's Eclipse Themes Text Editor Preview");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\uc724\uc2ac\uc544 \ud0c4\uc0dd 100\uc77c\uc744 \ucd95\ud558\ud55c\ub2e4.");
                _builder.newLine();
                _builder.append("\uc624\ub798\uc624\ub798 \uac74\uac15\ud558\uace0 \ud589\ubcf5\ud558\uac8c \uc0b4\uc790.");
                _builder.newLine();
                _builder.newLine();
                _builder.append("2014\ub144 8\uc6d4 20\uc77c \uc544\ube60\uac00.");
                _builder.newLine();
                Document _document = new Document(_builder.toString());
                this.preview.setDocument((IDocument)_document);
                Control _control = this.preview.getControl();
                Procedure1 _function_5 = it_2 -> {
                    it_2.widthHint = 200;
                    it_2.heightHint = 100;
                };
                _control.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL(_function_5));
            };
            this.previewWrap = swtExtensions.newComposite(it, 2048, _function_2);
            Procedure1 _function_3 = it_1 -> it_1.setText("Underline Style");
            swtExtensions.newLabel(it, _function_3);
            LineStyleEditor _lineStyleEditor = new LineStyleEditor((Composite)it);
            Procedures.Procedure1 _function_4 = it_1 -> {
                Control _control = it_1.getControl();
                _control.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_5 = it_2 -> helper.requestFastUpdatePreview();
                it_1.setSelectionHandler((Procedure1<LineStyleEditor>)_function_5);
            };
            this.underLineStyleEdit = _doubleArrow = (LineStyleEditor)ObjectExtensions.operator_doubleArrow((Object)_lineStyleEditor, (Procedures.Procedure1)_function_4);
            Procedure1 _function_5 = it_1 -> it_1.setText("Underline Color");
            swtExtensions.newLabel(it, _function_5);
            Procedure1 _function_6 = it_1 -> {
                Listener _function_7 = it_2 -> helper.requestFastUpdatePreview();
                swtExtensions.setOnModified((Control)it_1, _function_7);
            };
            this.underLineColorEdit = helper.newColorWell((Composite)it, (Procedure1<ColorWell>)_function_6);
            Procedure1 _function_7 = it_1 -> it_1.setText("Ruler Color");
            swtExtensions.newLabel(it, _function_7);
            Procedure1 _function_8 = it_1 -> {
                Listener _function_9 = it_2 -> helper.requestFastUpdatePreview();
                swtExtensions.setOnModified((Control)it_1, _function_9);
            };
            this.rulerColorEdit = helper.newColorWell((Composite)it, (Procedure1<ColorWell>)_function_8);
            Procedure1 _function_9 = it_1 -> {};
            swtExtensions.newHorizontalSeparator(it, _function_9);
            Procedure1 _function_10 = it_1 -> {
                Procedure1 _function_11 = it_2 -> {
                    it_2.horizontalSpan = 2;
                };
                it_1.setLayoutData((Object)swtExtensions.newGridData(_function_11));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("See also ");
                Functions.Function1 _function_12 = it_2 -> this.toHTML((PreferenceLink)it_2);
                String _smartJoin = this.smartJoin(ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.getLinks())), (Functions.Function1)_function_12), ", ", " and ");
                _builder.append(_smartJoin);
                _builder.append(".");
                it_1.setText(_builder.toString());
                Listener _function_13 = it_2 -> helper.navigateTo(it_2.text);
                swtExtensions.setOnSelection((Widget)it_1, _function_13);
            };
            swtExtensions.newLink(it, _function_10);
        };
        return swtExtensions.newComposite(parent, _function);
    }

    @Override
    public void updatePreview(CTabFolder folder, JTabSettings renderSettings, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        EditorLineSupport _get = EditorLineSupport.get((StyledText)this.preview.getTextWidget());
        Procedures.Procedure1 _function = it -> {
            it.setLineColor(this.underLineColorEdit.getSelection());
            it.setLineStyle(this.underLineStyleEdit.getSelection());
        };
        ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        swtExtensions.safeDispose((Resource)this.preview.getTextWidget().getBackground());
        swtExtensions.safeDispose((Resource)this.textEditorBackground);
        StyledText _textWidget = this.preview.getTextWidget();
        this.textEditorBackground = swtExtensions.newColor(this.computeTextEditorBackground());
        _textWidget.setBackground(this.textEditorBackground);
        this.lineNumberRulerColumn.setBackground(this.textEditorBackground);
        swtExtensions.safeDispose((Resource)this.lineNumberColor);
        this.lineNumberColor = swtExtensions.newColor(this.computeLineNumberForeground());
        this.lineNumberRulerColumn.setForeground(this.lineNumberColor);
        swtExtensions.safeDispose((Resource)this.textEditorForeground);
        this.textEditorForeground = swtExtensions.newColor(this.computeTextEditorForeground());
        StyledText _textWidget_1 = this.preview.getTextWidget();
        _textWidget_1.setForeground(this.textEditorForeground);
        swtExtensions.safeDispose((Resource)this.rulerColor);
        this.rulerColor = swtExtensions.newColor(this.rulerColorEdit.getSelection());
        this.previewWrap.setBackground(this.rulerColor);
    }

    @Override
    public void load(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        HSB rulerColor;
        this.underLineStyleEdit.setSelection(store.getInt("TEXT_EDITOR__UNDER_LINE_STYLE"));
        HSB underLineColor = store.getHSB("TEXT_EDITOR__UNDER_LINE_COLOR");
        if (underLineColor != null) {
            this.underLineColorEdit.setSelection(underLineColor);
        }
        if ((rulerColor = store.getHSB("TEXT_EDITOR__RULER_COLOR")) != null) {
            this.rulerColorEdit.setSelection(rulerColor);
        }
    }

    @Override
    public void save(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        store.setValue("TEXT_EDITOR__UNDER_LINE_STYLE", this.underLineStyleEdit.getSelection());
        store.setValue("TEXT_EDITOR__UNDER_LINE_COLOR", this.underLineColorEdit.getSelection());
        store.setValue("TEXT_EDITOR__RULER_COLOR", this.rulerColorEdit.getSelection());
    }

    @Override
    public void dispose(@Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        swtExtensions.safeDispose(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Color[]{this.textEditorBackground, this.textEditorForeground, this.rulerColor, this.lineNumberColor})));
    }

    private HSB computeTextEditorBackground() {
        boolean _equals;
        boolean _isRunning = Platform.isRunning();
        boolean bl = _equals = !_isRunning;
        if (_equals) {
            return HSB.WHITE;
        }
        String exp = EditorsUI.getPreferenceStore().getString("AbstractTextEditor.Color.Background");
        Functions.Function1 _function = it -> Integer.parseInt(it);
        List rgbArr = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)exp.split(","))), (Functions.Function1)_function);
        Integer _get = (Integer)rgbArr.get(0);
        Integer _get_1 = (Integer)rgbArr.get(1);
        Integer _get_2 = (Integer)rgbArr.get(2);
        RGB rgb = new RGB(_get.intValue(), _get_1.intValue(), _get_2.intValue());
        return new HSB(rgb);
    }

    private HSB computeTextEditorForeground() {
        boolean _equals;
        boolean _isRunning = Platform.isRunning();
        boolean bl = _equals = !_isRunning;
        if (_equals) {
            return HSB.BLACK;
        }
        String exp = EditorsUI.getPreferenceStore().getString("AbstractTextEditor.Color.Foreground");
        Functions.Function1 _function = it -> Integer.parseInt(it);
        List rgbArr = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)exp.split(","))), (Functions.Function1)_function);
        Integer _get = (Integer)rgbArr.get(0);
        Integer _get_1 = (Integer)rgbArr.get(1);
        Integer _get_2 = (Integer)rgbArr.get(2);
        RGB rgb = new RGB(_get.intValue(), _get_1.intValue(), _get_2.intValue());
        return new HSB(rgb);
    }

    private HSB computeLineNumberForeground() {
        boolean _equals;
        boolean _isRunning = Platform.isRunning();
        boolean bl = _equals = !_isRunning;
        if (_equals) {
            return HSB.BLACK;
        }
        String exp = EditorsUI.getPreferenceStore().getString("lineNumberColor");
        Functions.Function1 _function = it -> Integer.parseInt(it);
        List rgbArr = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)exp.split(","))), (Functions.Function1)_function);
        Integer _get = (Integer)rgbArr.get(0);
        Integer _get_1 = (Integer)rgbArr.get(1);
        Integer _get_2 = (Integer)rgbArr.get(2);
        RGB rgb = new RGB(_get.intValue(), _get_1.intValue(), _get_2.intValue());
        return new HSB(rgb);
    }

    private PreferenceLink[] getLinks() {
        boolean _isPreferencePageExists_1;
        boolean _equals;
        boolean _isRunning = Platform.isRunning();
        boolean bl = _equals = !_isRunning;
        if (_equals) {
            return new PreferenceLink[0];
        }
        ArrayList<PreferenceLink> result = new ArrayList<PreferenceLink>();
        boolean _isPreferencePageExists = this.isPreferencePageExists(PREF_ID_EDITBOX);
        if (_isPreferencePageExists) {
            PreferenceLink _preferenceLink = new PreferenceLink("EditBox", PREF_ID_EDITBOX);
            result.add(_preferenceLink);
        }
        if (_isPreferencePageExists_1 = this.isPreferencePageExists(PREF_ID_COLOR_THEME)) {
            PreferenceLink _preferenceLink_1 = new PreferenceLink("Eclipse Color Theme", PREF_ID_COLOR_THEME);
            result.add(_preferenceLink_1);
        }
        PreferenceLink _preferenceLink_2 = new PreferenceLink("Text Editors Section", PREF_ID_GENERAL_TEXT_EDITORS);
        result.add(_preferenceLink_2);
        return (PreferenceLink[])Conversions.unwrapArray(result, PreferenceLink.class);
    }

    private boolean isPreferencePageExists(String id) {
        boolean _xblockexpression = false;
        IExtensionPoint prefNodes = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.preferencePages");
        Functions.Function1 _function = it -> {
            String _attribute = it.getAttribute("id");
            return Objects.equal((Object)_attribute, (Object)id);
        };
        _xblockexpression = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)prefNodes.getConfigurationElements())), (Functions.Function1)_function);
        return _xblockexpression;
    }

    private String smartJoin(Iterable<String> segments, String delimeter1, String delimeter2) {
        boolean _greaterThan;
        int _length = ((Object[])Conversions.unwrapArray(segments, Object.class)).length;
        boolean bl = _greaterThan = _length > 2;
        if (_greaterThan) {
            List _list = IterableExtensions.toList(segments);
            int _length_1 = ((Object[])Conversions.unwrapArray(segments, Object.class)).length;
            int _minus = _length_1 - 1;
            String _join = IterableExtensions.join(_list.subList(0, _minus), (CharSequence)delimeter1);
            String _plus = String.valueOf(_join) + delimeter2;
            String _last = (String)IterableExtensions.last(segments);
            return String.valueOf(_plus) + _last;
        }
        return IterableExtensions.join(segments, (CharSequence)delimeter2);
    }

    private String toHTML(PreferenceLink link) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<a href=\"");
        String _prefId = link.getPrefId();
        _builder.append(_prefId);
        _builder.append("\">");
        String _name = link.getName();
        _builder.append(_name);
        _builder.append("</a>");
        return _builder.toString();
    }
}

