/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import java.util.ArrayList;
import java.util.List;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.rendering.JeeeyulsTabRenderer;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.AbstractJTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.JTPreferencePage;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorPicker;
import net.jeeeyul.swtend.ui.ColorStop;
import net.jeeeyul.swtend.ui.ColorWell;
import net.jeeeyul.swtend.ui.Gradient;
import net.jeeeyul.swtend.ui.GradientEdit;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreperencePageHelper {
    private JTPreferencePage root;
    private AbstractJTPreferencePage client;

    public PreperencePageHelper(JTPreferencePage root, AbstractJTPreferencePage client) {
        this.root = root;
        this.client = client;
    }

    public Label appendMonitor(final Scale scale, final String unit, final int delta) {
        final Label label = new Label(scale.getParent(), 0);
        scale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                label.setText(String.valueOf(scale.getSelection() + delta) + unit);
            }
        });
        label.setLayoutData((Object)new GridData(40, -1));
        label.setText(String.valueOf(scale.getSelection() + delta) + unit);
        SWTExtensions.INSTANCE.asyncExec((Procedure1)new Procedure1<Void>(){

            public void apply(Void t) {
                if (scale.isDisposed()) {
                    return;
                }
                label.setText(String.valueOf(scale.getSelection() + delta) + unit);
            }
        });
        return label;
    }

    public Button appendOrderLockButton(final GradientEdit gradEdit, Procedure1<Button> initializer) {
        final Button button = new Button(gradEdit.getParent(), 32);
        button.setText("Lock Order");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                gradEdit.setLockOrder(button.getSelection());
            }
        });
        if (initializer != null) {
            initializer.apply((Object)button);
        }
        return button;
    }

    public List<HSB> asSWTSafeHSBArray(Gradient gradient) {
        ArrayList<HSB> result = new ArrayList<HSB>();
        ColorStop first = gradient.get(0);
        if (first.percent != 0) {
            result.add(first.color);
        }
        for (ColorStop each : gradient) {
            result.add(each.color);
        }
        ColorStop last = gradient.get(gradient.size() - 1);
        if (last.percent != 100) {
            result.add(last.color);
        }
        return result;
    }

    public List<Integer> asSWTSafePercentArray(Gradient gradient) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        ColorStop first = gradient.get(0);
        if (first.percent != 0) {
            result.add(first.percent);
        }
        int i = 1;
        while (i < gradient.size()) {
            ColorStop each = gradient.get(i);
            result.add(each.percent);
            ++i;
        }
        ColorStop last = gradient.get(gradient.size() - 1);
        if (last.percent != 100) {
            result.add(100);
        }
        return result;
    }

    public AbstractJTPreferencePage getActivePage() {
        return this.root.getActivePage();
    }

    public JThemePreferenceStore getPreferenceStore() {
        return this.root.getPreferenceStore();
    }

    public JTPreferencePage getRootPage() {
        return this.root;
    }

    public boolean matches(Color[] colors, HSB[] hsbArray) {
        if (colors == null) {
            return false;
        }
        if (colors.length != hsbArray.length) {
            return false;
        }
        int i = 0;
        while (i < colors.length) {
            if (colors[i].isDisposed()) {
                return false;
            }
            if (!colors[i].getRGB().equals((Object)hsbArray[i].toRGB())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(Color color, HSB hsb) {
        if (color == null || color.isDisposed()) {
            return false;
        }
        return new HSB(color.getRGB()).equals((Object)hsb);
    }

    public ColorWell newColorWell(Composite parent, Procedure1<ColorWell> initializer) {
        final ColorWell result = new ColorWell(parent, 0);
        result.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HSB original = result.getSelection();
                ColorPicker picker = new ColorPicker(result.getShell());
                picker.setSelection(original);
                picker.setContinuosSelectionHandler((Procedure1)new Procedure1<HSB>(){

                    public void apply(HSB t) {
                        result.setSelection(t);
                    }
                });
                if (picker.open() == 0) {
                    result.setSelection(picker.getSelection());
                } else {
                    result.setSelection(original);
                }
            }
        });
        if (initializer != null) {
            initializer.apply((Object)result);
        }
        return result;
    }

    public GradientEdit newGradientEdit(Composite parent, Procedure1<GradientEdit> initializer) {
        GradientEdit result = new GradientEdit(parent);
        if (initializer != null) {
            initializer.apply((Object)result);
        }
        return result;
    }

    public void requestFastUpdatePreview() {
        CTabFolder folder = this.getRootPage().getFolder();
        JeeeyulsTabRenderer renderer = (JeeeyulsTabRenderer)folder.getRenderer();
        JTabSettings settings = renderer.getSettings();
        this.client.updatePreview(folder, settings, SWTExtensions.INSTANCE, this);
    }

    public void requestUpdatePreview() {
        this.root.updatePreview();
    }

    public AbstractJTPreferencePage[] getAllPages() {
        return this.root.getAllPages();
    }

    public void navigateTo(String id) {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.root.getShell(), (String)id, null, null);
    }

    public JThemePreferenceStore createWorkingCopy() {
        JThemePreferenceStore fakeStore = new JThemePreferenceStore((IPersistentPreferenceStore)new PreferenceStore());
        this.root.saveTo(fakeStore);
        return fakeStore;
    }

    public void loadFromWorkingCopy(JThemePreferenceStore store) {
        this.root.loadFrom(store);
    }
}

