/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import net.jeeeyul.swtend.sam.Procedure1;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LineWidthEditor {
    private Button thinButton;
    private Button normalButton;
    private Button boldButton;
    private Procedure1<Integer> selectionHandler;
    private Composite control;

    public Composite getControl() {
        return this.control;
    }

    public LineWidthEditor(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.control.setLayout((Layout)layout);
        this.thinButton = new Button(this.control, 16);
        this.thinButton.setText("Thin");
        this.normalButton = new Button(this.control, 16);
        this.normalButton.setSelection(true);
        this.normalButton.setText("Normal");
        this.boldButton = new Button(this.control, 16);
        this.boldButton.setText("Bold");
        Listener hook = new Listener(){

            public void handleEvent(Event event) {
                LineWidthEditor.this.handleSelection();
            }
        };
        this.thinButton.addListener(13, hook);
        this.normalButton.addListener(13, hook);
        this.boldButton.addListener(13, hook);
    }

    public int getSelection() {
        if (this.boldButton.getSelection()) {
            return 3;
        }
        if (this.thinButton.getSelection()) {
            return 1;
        }
        return 2;
    }

    public Procedure1<Integer> getSelectionHandler() {
        return this.selectionHandler;
    }

    private void handleSelection() {
        if (this.selectionHandler != null) {
            this.selectionHandler.apply((Object)this.getSelection());
        }
    }

    public void setSelection(int selection) {
        if (this.getSelection() == selection) {
            return;
        }
        this.thinButton.setSelection(false);
        this.normalButton.setSelection(false);
        this.boldButton.setSelection(false);
        switch (selection) {
            case 3: {
                this.boldButton.setSelection(true);
                break;
            }
            case 1: {
                this.thinButton.setSelection(true);
                break;
            }
            default: {
                this.normalButton.setSelection(true);
            }
        }
    }

    public void setSelectionHandler(Procedure1<Integer> selectionHandler) {
        this.selectionHandler = selectionHandler;
    }
}

