/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class LineStyleEditor {
    private Button[] buttons;
    private Procedure1<LineStyleEditor> selectionHandler;
    private Composite composite;

    public LineStyleEditor(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        this.composite.setLayout((Layout)layout);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LineStyleEditor.this.fireSelection();
            }
        };
        this.buttons = new Button[4];
        this.buttons[0] = new Button(this.composite, 16);
        this.buttons[0].setText("None");
        this.buttons[0].setData((Object)0);
        this.buttons[1] = new Button(this.composite, 16);
        this.buttons[1].setText("Solid");
        this.buttons[1].setData((Object)1);
        this.buttons[2] = new Button(this.composite, 16);
        this.buttons[2].setText("Dashed");
        this.buttons[2].setData((Object)2);
        this.buttons[3] = new Button(this.composite, 16);
        this.buttons[3].setText("Dotted");
        this.buttons[3].setData((Object)3);
        SWTExtensions.INSTANCE.attachTo(listener, 13, (Widget[])this.buttons);
    }

    private void fireSelection() {
        if (this.selectionHandler != null) {
            this.selectionHandler.apply((Object)this);
        }
    }

    public int getSelection() {
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button each = buttonArray[n2];
            if (each.getSelection()) {
                return (Integer)each.getData();
            }
            ++n2;
        }
        return 0;
    }

    public Procedure1<LineStyleEditor> getSelectionHandler() {
        return this.selectionHandler;
    }

    public Control getControl() {
        return this.composite;
    }

    public void setSelection(int lineStyle) {
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button each;
            int data = (Integer)(each = buttonArray[n2]).getData();
            each.setSelection(data == lineStyle);
            ++n2;
        }
    }

    public void setSelectionHandler(Procedure1<LineStyleEditor> selectionHandler) {
        this.selectionHandler = selectionHandler;
    }
}

