/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import com.google.common.base.Objects;
import java.util.List;
import net.jeeeyul.eclipse.themes.SharedImages;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.rendering.VerticalAlignment;
import net.jeeeyul.eclipse.themes.ui.internal.ENVHelper;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.AbstractJTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreperencePageHelper;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LayoutPage
extends AbstractJTPreferencePage {
    private Spinner borderRadiusScale;
    private Spinner paddingsScale;
    private Spinner tabItemPaddingsScale;
    private Spinner tabSpacingScale;
    private Spinner tabItemSpacingScale;
    private Spinner tabHeightScale;
    private Button truncateTabItemsButton;
    private Button truncateEditorTabItemsButton;
    private Button useEllipsesButton;
    private Spinner minimumCharactersSpinner;
    private Spinner minimumCharactersForEditorSpinner;
    private List<Button> closeButtonAlignButtons;

    public LayoutPage() {
        super("Layout");
        this.setImage(SharedImages.getImage("icons/layout.gif"));
    }

    @Override
    public Control createContents(Composite parent, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        Procedure1 _function = it -> {
            Procedure1 _function_1 = it_1 -> {};
            it.setLayout((Layout)swtExtensions.newGridLayout(_function_1));
            Procedure1 _function_2 = it_1 -> {
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_3 = it_2 -> {
                    it_2.numColumns = 3;
                };
                it_1.setLayout((Layout)swtExtensions.newGridLayout(_function_3));
                Procedure1 _function_4 = it_2 -> it_2.setText("Border Radius");
                swtExtensions.newLabel(it_1, _function_4);
                Procedure1 _function_5 = it_2 -> {
                    it_2.setMinimum(0);
                    it_2.setMaximum(10);
                    it_2.setSelection(3);
                    Listener _function_6 = it_3 -> helper.requestFastUpdatePreview();
                    swtExtensions.setOnSelection((Widget)it_2, _function_6);
                    Procedure1 _function_7 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_7));
                };
                this.borderRadiusScale = swtExtensions.newSpinner(it_1, _function_5);
                Procedure1 _function_6 = it_2 -> {
                    it_2.setText("0 ~ 10px");
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                swtExtensions.newLabel(it_1, _function_6);
                Procedure1 _function_7 = it_2 -> it_2.setText("Tab Item Paddings");
                swtExtensions.newLabel(it_1, _function_7);
                Procedure1 _function_8 = it_2 -> {
                    it_2.setMinimum(0);
                    it_2.setMaximum(10);
                    it_2.setSelection(2);
                    Listener _function_9 = it_3 -> helper.requestFastUpdatePreview();
                    swtExtensions.setOnSelection((Widget)it_2, _function_9);
                    Procedure1 _function_10 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_10));
                };
                this.tabItemPaddingsScale = swtExtensions.newSpinner(it_1, _function_8);
                Procedure1 _function_9 = it_2 -> {
                    it_2.setText("0 ~ 10px");
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                swtExtensions.newLabel(it_1, _function_9);
                Procedure1 _function_10 = it_2 -> it_2.setText("Content Paddings");
                swtExtensions.newLabel(it_1, _function_10);
                Procedure1 _function_11 = it_2 -> {
                    it_2.setMinimum(0);
                    it_2.setMaximum(10);
                    it_2.setSelection(2);
                    Listener _function_12 = it_3 -> helper.requestFastUpdatePreview();
                    swtExtensions.setOnSelection((Widget)it_2, _function_12);
                    Procedure1 _function_13 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_13));
                };
                this.paddingsScale = swtExtensions.newSpinner(it_1, _function_11);
                Procedure1 _function_12 = it_2 -> {
                    it_2.setText("0 ~ 10px");
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                swtExtensions.newLabel(it_1, _function_12);
                Procedure1 _function_13 = it_2 -> it_2.setText("Tab Spacing");
                swtExtensions.newLabel(it_1, _function_13);
                Procedure1 _function_14 = it_2 -> {
                    it_2.setMinimum(-1);
                    it_2.setMaximum(20);
                    it_2.setSelection(2);
                    Listener _function_15 = it_3 -> helper.requestFastUpdatePreview();
                    swtExtensions.setOnSelection((Widget)it_2, _function_15);
                    Procedure1 _function_16 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_16));
                };
                this.tabSpacingScale = swtExtensions.newSpinner(it_1, _function_14);
                Procedure1 _function_15 = it_2 -> {
                    it_2.setText("-1(Overlap) ~ 20px");
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                swtExtensions.newLabel(it_1, _function_15);
                Procedure1 _function_16 = it_2 -> it_2.setText("Part Icon, Title and Close Spacing");
                swtExtensions.newLabel(it_1, _function_16);
                Procedure1 _function_17 = it_2 -> {
                    it_2.setMinimum(0);
                    it_2.setMaximum(10);
                    it_2.setSelection(2);
                    Listener _function_18 = it_3 -> helper.requestFastUpdatePreview();
                    swtExtensions.setOnSelection((Widget)it_2, _function_18);
                    Procedure1 _function_19 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_19));
                };
                this.tabItemSpacingScale = swtExtensions.newSpinner(it_1, _function_17);
                Procedure1 _function_18 = it_2 -> {
                    it_2.setText("0 ~ 10px");
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                swtExtensions.newLabel(it_1, _function_18);
                Procedure1 _function_19 = it_2 -> it_2.setText("Tab Height");
                swtExtensions.newLabel(it_1, _function_19);
                Procedure1 _function_20 = it_2 -> {
                    it_2.setMinimum(swtExtensions.getMinimumToolBarHeight());
                    it_2.setMaximum(40);
                    it_2.setSelection(swtExtensions.getMinimumToolBarHeight());
                    Listener _function_21 = it_3 -> helper.requestUpdatePreview();
                    swtExtensions.setOnSelection((Widget)it_2, _function_21);
                    Procedure1 _function_22 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_22));
                };
                this.tabHeightScale = swtExtensions.newSpinner(it_1, _function_20);
                Procedure1 _function_21 = it_2 -> {
                    StringConcatenation _builder = new StringConcatenation();
                    int _minimumToolBarHeight = swtExtensions.getMinimumToolBarHeight();
                    _builder.append((Object)_minimumToolBarHeight);
                    _builder.append(" ~ 40px");
                    it_2.setText(_builder.toString());
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                swtExtensions.newLabel(it_1, _function_21);
                Procedure1 _function_22 = it_2 -> it_2.setText("Close Button Alignment");
                swtExtensions.newLabel(it_1, _function_22);
                Procedure1 _function_23 = it_2 -> {
                    VerticalAlignment[] _values;
                    Procedure1 _function_24 = it_3 -> {
                        it_3.numColumns = VerticalAlignment.values().length;
                        it_3.marginWidth = 0;
                        it_3.marginHeight = 0;
                    };
                    it_2.setLayout((Layout)swtExtensions.newGridLayout(_function_24));
                    Procedure1 _function_25 = it_3 -> {
                        it_3.horizontalSpan = 2;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_25));
                    this.closeButtonAlignButtons = CollectionLiterals.newArrayList((Object[])new Button[0]);
                    VerticalAlignment[] verticalAlignmentArray = _values = VerticalAlignment.values();
                    int n = _values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VerticalAlignment each = verticalAlignmentArray[n2];
                        Procedure1 _function_26 = it_3 -> {
                            it_3.setText(each.getName());
                            it_3.setData((Object)each);
                            Listener _function_27 = it_4 -> helper.requestFastUpdatePreview();
                            swtExtensions.setOnSelection((Widget)it_3, _function_27);
                        };
                        Button _newRadioButton = swtExtensions.newRadioButton(it_2, _function_26);
                        this.closeButtonAlignButtons.add(_newRadioButton);
                        ++n2;
                    }
                };
                swtExtensions.newComposite(it_1, _function_23);
            };
            swtExtensions.newComposite(it, _function_2);
            Procedure1 _function_3 = it_1 -> {
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_4 = it_2 -> {
                    it_2.numColumns = 1;
                };
                it_1.setLayout((Layout)swtExtensions.newGridLayout(_function_4));
                Procedure1 _function_5 = it_2 -> {
                    it_2.setText("Truncate Tab Items to show more Tab Items");
                    Listener _function_6 = it_3 -> helper.requestFastUpdatePreview();
                    swtExtensions.setOnSelection((Widget)it_2, _function_6);
                };
                this.truncateTabItemsButton = swtExtensions.newCheckbox(it_1, _function_5);
                Procedure1 _function_6 = it_2 -> {
                    it_2.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                    Procedure1 _function_7 = it_3 -> {
                        it_3.numColumns = 2;
                    };
                    it_2.setLayout((Layout)swtExtensions.newGridLayout(_function_7));
                    Procedure1 _function_8 = it_3 -> it_3.setText("Minimum number of characters");
                    swtExtensions.newLabel((Composite)it_2, _function_8);
                    Procedure1 _function_9 = it_3 -> {
                        Procedure1 _function_10 = it_4 -> {
                            it_4.minimumWidth = 40;
                        };
                        it_3.setLayoutData((Object)swtExtensions.newGridData(_function_10));
                        it_3.setMinimum(1);
                        it_3.setMaximum(20);
                        Listener _function_11 = it_4 -> helper.requestFastUpdatePreview();
                        swtExtensions.setOnSelection((Widget)it_3, _function_11);
                    };
                    this.minimumCharactersSpinner = swtExtensions.newSpinner((Composite)it_2, _function_9);
                    Procedure1 _function_10 = it_3 -> {
                        it_3.setText("Use Ellipses when truncating");
                        Procedure1 _function_11 = it_4 -> {
                            it_4.horizontalSpan = 2;
                        };
                        it_3.setLayoutData((Object)swtExtensions.newGridData(_function_11));
                        Listener _function_12 = it_4 -> helper.requestFastUpdatePreview();
                        swtExtensions.setOnSelection((Widget)it_3, _function_12);
                    };
                    this.useEllipsesButton = swtExtensions.newCheckbox((Composite)it_2, _function_10);
                    Procedure1 _function_11 = it_3 -> {
                        it_3.setText("Truncate Editors also");
                        Procedure1 _function_12 = it_4 -> {
                            it_4.horizontalSpan = 2;
                        };
                        it_3.setLayoutData((Object)swtExtensions.newGridData(_function_12));
                        Listener _function_13 = it_4 -> helper.requestFastUpdatePreview();
                        swtExtensions.setOnSelection((Widget)it_3, _function_13);
                    };
                    this.truncateEditorTabItemsButton = swtExtensions.newCheckbox((Composite)it_2, _function_11);
                    Procedure1 _function_12 = it_3 -> {
                        it_3.setText("Minimum number of characters for Editors");
                        Procedure1 _function_13 = it_4 -> {
                            it_4.horizontalIndent = 16;
                        };
                        it_3.setLayoutData((Object)swtExtensions.newGridData(_function_13));
                    };
                    swtExtensions.newLabel((Composite)it_2, _function_12);
                    Procedure1 _function_13 = it_3 -> {
                        Procedure1 _function_14 = it_4 -> {
                            it_4.minimumWidth = 40;
                        };
                        it_3.setLayoutData((Object)swtExtensions.newGridData(_function_14));
                        it_3.setMinimum(1);
                        it_3.setMaximum(20);
                        Listener _function_15 = it_4 -> helper.requestFastUpdatePreview();
                        swtExtensions.setOnSelection((Widget)it_3, _function_15);
                    };
                    this.minimumCharactersForEditorSpinner = swtExtensions.newSpinner((Composite)it_2, _function_13);
                };
                swtExtensions.newGroup(it_1, _function_6);
            };
            swtExtensions.newComposite(it, _function_3);
            boolean _isLinux = ENVHelper.INSTANCE.isLinux();
            if (_isLinux) {
                Procedure1 _function_4 = it_1 -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("To reduce limit on minimum tab height, refer to <a href=\"https://github.com/jeeeyul/eclipse-themes/wiki/Linux-User-Guide\">Linux User Guide</a>.");
                    it_1.setText(_builder.toString());
                    Procedure1 _function_5 = it_2 -> {
                        it_2.horizontalSpan = 3;
                    };
                    it_1.setLayoutData((Object)swtExtensions.newGridData(_function_5));
                    Listener _function_6 = it_2 -> Program.launch((String)it_2.text);
                    swtExtensions.setOnSelection((Widget)it_1, _function_6);
                };
                swtExtensions.newLink(it, _function_4);
            }
        };
        return swtExtensions.newComposite(parent, _function);
    }

    @Override
    public void updatePreview(CTabFolder folder, JTabSettings renderSettings, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        renderSettings.setBorderRadius(this.borderRadiusScale.getSelection());
        renderSettings.setPaddings(swtExtensions.newInsets(this.paddingsScale.getSelection()));
        renderSettings.setTabItemPaddings(swtExtensions.newInsets(this.tabItemPaddingsScale.getSelection()));
        renderSettings.setTabSpacing(this.tabSpacingScale.getSelection());
        renderSettings.setTabItemHorizontalSpacing(this.tabItemSpacingScale.getSelection());
        renderSettings.setUseEllipses(this.useEllipsesButton.getSelection());
        renderSettings.setMinimumCharacters(this.minimumCharactersSpinner.getSelection());
        renderSettings.setTruncateTabItems(this.truncateTabItemsButton.getSelection());
        Functions.Function1 _function = it -> it.getSelection();
        Object _data = ((Button)IterableExtensions.findFirst(this.closeButtonAlignButtons, (Functions.Function1)_function)).getData();
        renderSettings.setCloseButtonAlignment((VerticalAlignment)_data);
        this.useEllipsesButton.setEnabled(this.truncateTabItemsButton.getSelection());
        this.minimumCharactersSpinner.setEnabled(this.truncateTabItemsButton.getSelection());
        this.truncateEditorTabItemsButton.setEnabled(this.truncateTabItemsButton.getSelection());
        this.minimumCharactersForEditorSpinner.setEnabled(this.truncateEditorTabItemsButton.getSelection() && this.truncateTabItemsButton.getSelection());
        folder.setTabHeight(this.tabHeightScale.getSelection());
        Event _event = new Event();
        folder.notifyListeners(11, _event);
        folder.layout(true, true);
    }

    @Override
    public void load(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        this.borderRadiusScale.setSelection(store.getInt("LAYOUT__BORDER_RADIUS"));
        this.paddingsScale.setSelection(store.getInt("LAYOUT__CONTENT_PADDING"));
        this.tabHeightScale.setSelection(Math.max(store.getInt("LAYOUT__TAB_HEIGHT"), swtExtensions.getMinimumToolBarHeight()));
        this.tabSpacingScale.setSelection(store.getInt("LAYOUT__TAB_SPACING"));
        this.tabItemPaddingsScale.setSelection(store.getInt("LAYOUT__TAB_ITEM_PADDING"));
        this.tabItemSpacingScale.setSelection(store.getInt("LAYOUT__TAB_ITEM_SPACING"));
        this.truncateTabItemsButton.setSelection(store.getBoolean("LAYOUT__TRUNCATE_TAB_ITEMS"));
        this.useEllipsesButton.setSelection(store.getBoolean("LAYOUT__USE_ELLIPSES"));
        this.minimumCharactersSpinner.setSelection(store.getInt("LAYOUT__MINIMUM_CHARACTERS"));
        this.truncateEditorTabItemsButton.setSelection(store.getBoolean("LAYOUT__TRUNCATE_EDITORS_TAB_ITEMS_ALSO"));
        this.minimumCharactersForEditorSpinner.setSelection(store.getInt("LAYOUT__MINIMUM_CHARACTERS_FOR_EDITORS"));
        VerticalAlignment closeButtonAlign = VerticalAlignment.fromValue((int)store.getInt("LAYOUT__CLOSE_BUTTON_VERTICAL_ALIGNMENT"));
        for (Button eachButton : this.closeButtonAlignButtons) {
            Object _data = eachButton.getData();
            boolean _equals = Objects.equal((Object)_data, (Object)closeButtonAlign);
            eachButton.setSelection(_equals);
        }
    }

    @Override
    public void save(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        store.setValue("LAYOUT__BORDER_RADIUS", this.borderRadiusScale.getSelection());
        store.setValue("LAYOUT__CONTENT_PADDING", this.paddingsScale.getSelection());
        store.setValue("LAYOUT__TAB_HEIGHT", this.tabHeightScale.getSelection());
        store.setValue("LAYOUT__TAB_SPACING", this.tabSpacingScale.getSelection());
        store.setValue("LAYOUT__TAB_ITEM_PADDING", this.tabItemPaddingsScale.getSelection());
        store.setValue("LAYOUT__TAB_ITEM_SPACING", this.tabItemSpacingScale.getSelection());
        store.setValue("LAYOUT__TRUNCATE_TAB_ITEMS", this.truncateTabItemsButton.getSelection());
        store.setValue("LAYOUT__USE_ELLIPSES", this.useEllipsesButton.getSelection());
        store.setValue("LAYOUT__MINIMUM_CHARACTERS", this.minimumCharactersSpinner.getSelection());
        store.setValue("LAYOUT__TRUNCATE_EDITORS_TAB_ITEMS_ALSO", this.truncateEditorTabItemsButton.getSelection());
        store.setValue("LAYOUT__MINIMUM_CHARACTERS_FOR_EDITORS", this.minimumCharactersForEditorSpinner.getSelection());
        Functions.Function1 _function = it -> it.getSelection();
        Object _data = ((Button)IterableExtensions.findFirst(this.closeButtonAlignButtons, (Functions.Function1)_function)).getData();
        VerticalAlignment selectedAlign = (VerticalAlignment)_data;
        store.setValue("LAYOUT__CLOSE_BUTTON_VERTICAL_ALIGNMENT", selectedAlign.getValue());
    }

    @Override
    public void dispose(@Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
    }
}

