/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.SharedImages;
import net.jeeeyul.eclipse.themes.rendering.JeeeyulsTabRenderer;
import net.jeeeyul.eclipse.themes.ui.hotswap.RewriteCustomTheme;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.actions.AddUserPresetAction;
import net.jeeeyul.eclipse.themes.ui.preference.actions.ContributedPresetItems;
import net.jeeeyul.eclipse.themes.ui.preference.actions.ManagePresetAction;
import net.jeeeyul.eclipse.themes.ui.preference.actions.ShowCSSAction;
import net.jeeeyul.eclipse.themes.ui.preference.actions.ShowEPFAction;
import net.jeeeyul.eclipse.themes.ui.preference.actions.UserPresetItems;
import net.jeeeyul.eclipse.themes.ui.preference.internal.AbstractJTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.ClosePrevent;
import net.jeeeyul.eclipse.themes.ui.preference.internal.DonationPanel;
import net.jeeeyul.eclipse.themes.ui.preference.internal.FormsPage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.GeneralPage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.IPreferenceFilter;
import net.jeeeyul.eclipse.themes.ui.preference.internal.JTPUtil;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PartStacksPage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreperencePageHelper;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreviewTabFolder;
import net.jeeeyul.eclipse.themes.ui.preference.internal.TextEditorPage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.ToolsPage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.UserCSSPage;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetCategory;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetManager;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class JTPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = JTPreferencePage.class.getCanonicalName();
    @Extension
    private SWTExtensions swtExt = SWTExtensions.INSTANCE;
    private Map<AbstractJTPreferencePage, PreperencePageHelper> helperMap = new HashMap<AbstractJTPreferencePage, PreperencePageHelper>();
    private Composite rootView;
    private JeeeyulsTabRenderer renderer;
    private CTabFolder folder;
    private List<AbstractJTPreferencePage> pages = new ArrayList<AbstractJTPreferencePage>();
    private MenuManager menuManager;
    private UIJob updatePreviewJob = this.swtExt.newUIJob(it -> {
        boolean _isAlive = this.swtExt.isAlive((Widget)this.getControl());
        if (_isAlive) {
            this.doUpdatePreview();
        }
    });
    @Accessors
    private String lastChoosedPresetId;

    public JTPreferencePage() {
        this.setTitle("Jeeeyul's Theme");
        GeneralPage _generalPage = new GeneralPage();
        this.pages.add(_generalPage);
        PartStacksPage _partStacksPage = new PartStacksPage();
        this.pages.add(_partStacksPage);
        TextEditorPage _textEditorPage = new TextEditorPage();
        this.pages.add(_textEditorPage);
        FormsPage _formsPage = new FormsPage();
        this.pages.add(_formsPage);
        UserCSSPage _userCSSPage = new UserCSSPage();
        this.pages.add(_userCSSPage);
        ToolsPage _toolsPage = new ToolsPage();
        this.pages.add(_toolsPage);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(JThemesCore.getDefault().getPreferenceStore());
    }

    public Control createContents(Composite parent) {
        MenuManager _menuManager;
        for (AbstractJTPreferencePage e : this.pages) {
            e.init(this.getHelper(e));
        }
        Procedure1 _function = it -> {
            Procedure1 _function_1 = it_1 -> {};
            it.setLayout((Layout)this.swtExt.newGridLayout(_function_1));
            PreviewTabFolder _previewTabFolder = new PreviewTabFolder((Composite)it, 64);
            this.folder = _previewTabFolder;
            Procedures.Procedure1 _function_2 = it_1 -> {
                JeeeyulsTabRenderer _jeeeyulsTabRenderer;
                Procedure1 _function_3 = it_2 -> {
                    it_2.widthHint = 450;
                };
                it_1.setLayoutData((Object)this.swtExt.FILL_HORIZONTAL(_function_3));
                it_1.setUnselectedCloseVisible(false);
                it_1.setMaximizeVisible(true);
                it_1.setMinimizeVisible(true);
                ClosePrevent _closePrevent = new ClosePrevent();
                it_1.addCTabFolder2Listener((CTabFolder2Listener)_closePrevent);
                JeeeyulsTabRenderer _renderer = this.renderer = (_jeeeyulsTabRenderer = new JeeeyulsTabRenderer(it_1));
                it_1.setRenderer((CTabFolderRenderer)_renderer);
                for (AbstractJTPreferencePage each : this.pages) {
                    Procedure1 _function_4 = it_2 -> {
                        it_2.setText(each.getName());
                        it_2.setImage(each.getImage());
                        it_2.setControl(each.createContents((Composite)this.folder, this.swtExt, this.getHelper(each)));
                        Control _control = it_2.getControl();
                        _control.setBackground(this.swtExt.COLOR_WHITE());
                        Control _control_1 = it_2.getControl();
                        ((Composite)_control_1).setBackgroundMode(2);
                        it_2.setData((Object)each);
                    };
                    this.swtExt.newCTabItem(it_1, _function_4);
                }
                this.folder.setSelection((CTabItem)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)this.folder.getItems()))));
                Listener _function_5 = it_2 -> this.updatePreview(this.getActivePage());
                this.swtExt.setOnSelection((Widget)it_1, _function_5);
            };
            ObjectExtensions.operator_doubleArrow((Object)this.folder, (Procedures.Procedure1)_function_2);
            DonationPanel _donationPanel = new DonationPanel((Composite)it);
            Procedures.Procedure1 _function_3 = it_1 -> {
                Control _control = this.getControl();
                _control.setLayoutData((Object)this.swtExt.FILL_HORIZONTAL());
            };
            ObjectExtensions.operator_doubleArrow((Object)_donationPanel, (Procedures.Procedure1)_function_3);
        };
        this.rootView = this.swtExt.newComposite(parent, _function);
        Procedure1 _function_1 = it -> {
            Procedure1 _function_2 = it_1 -> {
                it_1.setImage(SharedImages.getImage("icons/jtheme.png"));
                Listener _function_3 = it_2 -> {
                    this.menuManager.updateAll(true);
                    ToolItem item = (ToolItem)it_2.widget;
                    Menu m = this.menuManager.getMenu();
                    m.setLocation(item.getParent().toDisplay(this.swtExt.getTranslated(this.swtExt.getBottomLeft(item.getBounds()), 0, 2)));
                    m.setVisible(true);
                };
                this.swtExt.setOnSelection((Widget)it_1, _function_3);
            };
            this.swtExt.newToolItem(it, 4, _function_2);
        };
        this.folder.setTopRight((Control)this.swtExt.newToolBar((Composite)this.folder, _function_1));
        this.menuManager = _menuManager = new MenuManager();
        this.menuManager.createContextMenu((Control)this.folder);
        this.createActions();
        this.doLoad();
        this.doUpdatePreview();
        return this.rootView;
    }

    private MenuManager createActions() {
        Procedures.Procedure1 _function = it -> {
            boolean _tripleNotEquals;
            IJTPresetManager _presetManager = this.getPresetManager();
            boolean bl = _tripleNotEquals = _presetManager != null;
            if (_tripleNotEquals) {
                IJTPresetCategory[] _categories;
                String _name = this.getPresetManager().getUserCategory().getName();
                ImageDescriptor _imageDescriptor = SharedImages.getImageDescriptor("icons/preset.gif");
                MenuManager _menuManager = new MenuManager(_name, _imageDescriptor, "user.preset");
                Procedures.Procedure1 _function_1 = it_1 -> {
                    AddUserPresetAction _addUserPresetAction = new AddUserPresetAction(this);
                    it_1.add((IAction)_addUserPresetAction);
                    ManagePresetAction _managePresetAction = new ManagePresetAction(this);
                    it_1.add((IAction)_managePresetAction);
                    UserPresetItems _userPresetItems = new UserPresetItems(this);
                    it_1.add((IContributionItem)_userPresetItems);
                };
                MenuManager _doubleArrow = (MenuManager)ObjectExtensions.operator_doubleArrow((Object)_menuManager, (Procedures.Procedure1)_function_1);
                it.add((IContributionItem)_doubleArrow);
                IJTPresetCategory[] iJTPresetCategoryArray = _categories = this.getPresetManager().getCategories();
                int n = _categories.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean _notEquals;
                    IJTPresetCategory eachCategory = iJTPresetCategoryArray[n2];
                    IJTPresetCategory _userCategory = this.getPresetManager().getUserCategory();
                    boolean bl2 = _notEquals = !Objects.equal((Object)eachCategory, (Object)_userCategory);
                    if (_notEquals) {
                        String _name_1 = eachCategory.getName();
                        ImageDescriptor _imageDescriptor_1 = SharedImages.getImageDescriptor("icons/preset.gif");
                        MenuManager _menuManager_1 = new MenuManager(_name_1, _imageDescriptor_1, "contributed.preset");
                        Procedures.Procedure1 _function_2 = it_1 -> {
                            ContributedPresetItems _contributedPresetItems = new ContributedPresetItems(this, eachCategory);
                            it_1.add((IContributionItem)_contributedPresetItems);
                        };
                        MenuManager _doubleArrow_1 = (MenuManager)ObjectExtensions.operator_doubleArrow((Object)_menuManager_1, (Procedures.Procedure1)_function_2);
                        it.add((IContributionItem)_doubleArrow_1);
                    }
                    ++n2;
                }
            }
            Separator _separator = new Separator();
            it.add((IContributionItem)_separator);
            ShowCSSAction _showCSSAction = new ShowCSSAction(this);
            it.add((IAction)_showCSSAction);
            ShowEPFAction _showEPFAction = new ShowEPFAction(this);
            it.add((IAction)_showEPFAction);
        };
        return (MenuManager)ObjectExtensions.operator_doubleArrow((Object)this.menuManager, (Procedures.Procedure1)_function);
    }

    private void doLoad() {
        this.loadFrom(this.getPreferenceStore());
    }

    public boolean performOk() {
        this.saveTo(this.getPreferenceStore());
        this.getPreferenceStore().save();
        boolean _isRunning = Platform.isRunning();
        if (_isRunning) {
            new RewriteCustomTheme(true).rewrite();
        }
        return true;
    }

    public void saveTo(JThemePreferenceStore store) {
        Consumer<AbstractJTPreferencePage> _function = it -> it.save(store, this.swtExt, this.getHelper((AbstractJTPreferencePage)it));
        this.pages.forEach(_function);
        if (this.lastChoosedPresetId != null) {
            store.setValue("MEMENTO__LAST_CHOOSED_PRESET", this.lastChoosedPresetId);
        }
    }

    public void loadFrom(JThemePreferenceStore store) {
        for (AbstractJTPreferencePage each : this.pages) {
            each.load(store, this.swtExt, this.getHelper(each));
        }
        this.updatePreview();
    }

    protected void performDefaults() {
        PreferenceStore _preferenceStore = new PreferenceStore();
        JThemePreferenceStore dummy = new JThemePreferenceStore((IPersistentPreferenceStore)_preferenceStore);
        List<String> presetKeys = JTPUtil.listPreferenceKeys(IPreferenceFilter.FILTER_PRESET);
        for (String e : presetKeys) {
            dummy.setValue(e, this.getPreferenceStore().getDefaultString(e));
        }
        for (AbstractJTPreferencePage e_1 : this.pages) {
            e_1.load(dummy, this.swtExt, this.getHelper(e_1));
        }
        this.updatePreview();
    }

    public JThemePreferenceStore getPreferenceStore() {
        IPreferenceStore _preferenceStore = super.getPreferenceStore();
        return (JThemePreferenceStore)_preferenceStore;
    }

    public AbstractJTPreferencePage getActivePage() {
        Object _data = this.folder.getSelection().getData();
        return (AbstractJTPreferencePage)_data;
    }

    private void updatePreview(AbstractJTPreferencePage page) {
        page.updatePreview(this.folder, this.renderer.getSettings(), this.swtExt, this.getHelper(page));
    }

    public static void main(String[] args) {
        try {
            PreferenceStore store;
            JTPreferencePage prefPage;
            PreferenceManager manager;
            block5: {
                manager = new PreferenceManager();
                prefPage = new JTPreferencePage();
                PreferenceNode _preferenceNode = new PreferenceNode("Active", (IPreferencePage)prefPage);
                manager.addToRoot((IPreferenceNode)_preferenceNode);
                String userDir = System.getProperty("user.home");
                File file = new File(userDir, ".jet-dummy-pref");
                String _absolutePath = file.getAbsolutePath();
                store = new PreferenceStore(_absolutePath);
                Properties defaults = new Properties();
                defaults.load(JTPreferencePage.class.getResourceAsStream("default.epf"));
                Set<Object> _keySet = defaults.keySet();
                for (Object each : _keySet) {
                    store.setDefault((String)each, defaults.getProperty((String)each));
                }
                try {
                    store.load();
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) break block5;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            JThemePreferenceStore _jThemePreferenceStore = new JThemePreferenceStore((IPersistentPreferenceStore)store);
            prefPage.setPreferenceStore(_jThemePreferenceStore);
            new PreferenceDialog(null, manager).open();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void updatePreview() {
        this.updatePreviewJob.schedule();
    }

    public void doUpdatePreview() {
        boolean _not;
        boolean _isAlive = this.swtExt.isAlive((Widget)this.getControl());
        boolean bl = _not = !_isAlive;
        if (_not) {
            return;
        }
        for (AbstractJTPreferencePage p : this.pages) {
            this.updatePreview(p);
        }
        this.rootView.layout(new Control[]{this.folder});
    }

    public void dispose() {
        Consumer<AbstractJTPreferencePage> _function = it -> it.dispose(this.swtExt, this.getHelper((AbstractJTPreferencePage)it));
        this.pages.forEach(_function);
        super.dispose();
    }

    private PreperencePageHelper getHelper(AbstractJTPreferencePage page) {
        PreperencePageHelper result = this.helperMap.get(page);
        if (result == null) {
            PreperencePageHelper _preperencePageHelper;
            result = _preperencePageHelper = new PreperencePageHelper(this, page);
            this.helperMap.put(page, result);
        }
        return result;
    }

    public CTabFolder getFolder() {
        return this.folder;
    }

    public IJTPresetManager getPresetManager() {
        Object _xifexpression = null;
        boolean _isRunning = Platform.isRunning();
        if (_isRunning) {
            return JThemesCore.getDefault().getPresetManager();
        }
        _xifexpression = null;
        return _xifexpression;
    }

    public AbstractJTPreferencePage[] getAllPages() {
        ArrayList<AbstractJTPreferencePage> result = new ArrayList<AbstractJTPreferencePage>();
        for (AbstractJTPreferencePage each : this.pages) {
            result.add(each);
            CollectionExtensions.addAll(result, (Object[])each.getChildren());
        }
        return (AbstractJTPreferencePage[])Conversions.unwrapArray(result, AbstractJTPreferencePage.class);
    }

    @Pure
    public String getLastChoosedPresetId() {
        return this.lastChoosedPresetId;
    }

    public void setLastChoosedPresetId(String lastChoosedPresetId) {
        this.lastChoosedPresetId = lastChoosedPresetId;
    }
}

