/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.preference.JTPConstants;
import net.jeeeyul.eclipse.themes.ui.preference.annotations.Ignore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.IPreferenceFilter;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetManager;
import net.jeeeyul.eclipse.themes.ui.preference.preset.internal.UserPreset;
import org.eclipse.jface.dialogs.IInputValidator;

public class JTPUtil {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static void collectClasses(Class<?> root, List<Class<?>> result) {
        if (root == null || result == null) {
            throw new IllegalArgumentException();
        }
        result.add(root);
        Class<?>[] classArray = root.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> each = classArray[n2];
            JTPUtil.collectClasses(each, result);
            ++n2;
        }
    }

    public static IInputValidator getPresetNameValidator() {
        IInputValidator presetNameValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().length() == 0) {
                    return "Name must be specified.";
                }
                IJTPresetManager presetManager = JThemesCore.getDefault().getPresetManager();
                for (IJTPreset each : presetManager.getUserCategory().getPresets()) {
                    if (!each.getName().equalsIgnoreCase(newText)) continue;
                    return MessageFormat.format("{0} is already exists.", each.getName());
                }
                if (!UserPreset.isSafeName(newText)) {
                    return "Unsafe characters are contained.";
                }
                return null;
            }
        };
        return presetNameValidator;
    }

    public static final List<String> listPreferenceKeys(IPreferenceFilter filter) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList allCategories = new ArrayList();
        JTPUtil.collectClasses(JTPConstants.class, allCategories);
        for (Class clazz : allCategories) {
            if (clazz.getAnnotation(Ignore.class) != null || !filter.acceptCategory(clazz)) continue;
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field eachField = fieldArray[n2];
                if (eachField.getAnnotation(Ignore.class) == null && filter.acceptKey(eachField)) {
                    try {
                        result.add((String)eachField.get(clazz));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(JTPUtil.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(JTPUtil.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(JTPUtil.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(JTPUtil.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

