/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.internal;

import net.jeeeyul.eclipse.themes.SharedImages;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.ui.internal.ENVHelper;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.AbstractJTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PreperencePageHelper;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorWell;
import net.jeeeyul.swtend.ui.Gradient;
import net.jeeeyul.swtend.ui.GradientEdit;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GeneralPage
extends AbstractJTPreferencePage {
    private GradientEdit toolbarEdit;
    private GradientEdit statusEdit;
    private GradientEdit perspectiveSwitcherEdit;
    private ColorWell statusTextColorWell;
    private ColorWell perspectiveSwitcherKeyLineColorWell;
    private ColorWell perspectiveTextColorWell;
    private ColorWell backgroundEdit;
    private Button castShadowEdit;
    private ColorWell shadowColorWell;
    private Spinner partStackSpacingEdit;
    private Label partStackSpacingRangeLabel;
    private Spinner windowMarginsEdit;
    private Label windowMarginsRangeLabel;

    public GeneralPage() {
        super("General");
        this.setImage(SharedImages.getImage("icons/layout.gif"));
    }

    @Override
    public Control createContents(Composite parent, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        Procedure1 _function = it -> {
            Procedure1 _function_1 = it_1 -> {};
            it.setLayout((Layout)swtExtensions.newGridLayout(_function_1));
            Procedure1 _function_2 = it_1 -> {
                it_1.setText("Window");
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_3 = it_2 -> {
                    it_2.numColumns = 3;
                };
                it_1.setLayout((Layout)swtExtensions.newGridLayout(_function_3));
                Procedure1 _function_4 = it_2 -> it_2.setText("Background");
                swtExtensions.newLabel((Composite)it_1, _function_4);
                Procedure1 _function_5 = it_2 -> {
                    Procedure1 _function_6 = it_3 -> {
                        it_3.horizontalSpan = 2;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_6));
                };
                this.backgroundEdit = helper.newColorWell((Composite)it_1, (Procedure1<ColorWell>)_function_5);
                Procedure1 _function_6 = it_2 -> it_2.setText("Tool Bar");
                swtExtensions.newLabel((Composite)it_1, _function_6);
                Procedure1 _function_7 = it_2 -> it_2.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                this.toolbarEdit = helper.newGradientEdit((Composite)it_1, (Procedure1<GradientEdit>)_function_7);
                Procedure1 _function_8 = it_2 -> {};
                helper.appendOrderLockButton(this.toolbarEdit, (Procedure1<Button>)_function_8);
                Procedure1 _function_9 = it_2 -> it_2.setText("Status Bar");
                swtExtensions.newLabel((Composite)it_1, _function_9);
                Procedure1 _function_10 = it_2 -> it_2.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                this.statusEdit = helper.newGradientEdit((Composite)it_1, (Procedure1<GradientEdit>)_function_10);
                Procedure1 _function_11 = it_2 -> {};
                helper.appendOrderLockButton(this.statusEdit, (Procedure1<Button>)_function_11);
                Procedure1 _function_12 = it_2 -> it_2.setText("Status Bar Text");
                swtExtensions.newLabel((Composite)it_1, _function_12);
                Procedure1 _function_13 = it_2 -> {
                    Procedure1 _function_14 = it_3 -> {
                        it_3.horizontalSpan = 2;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_14));
                };
                this.statusTextColorWell = helper.newColorWell((Composite)it_1, (Procedure1<ColorWell>)_function_13);
            };
            swtExtensions.newGroup(it, _function_2);
            Procedure1 _function_3 = it_1 -> {
                it_1.setText("Perspective Switcher");
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_4 = it_2 -> {
                    it_2.numColumns = 4;
                };
                it_1.setLayout((Layout)swtExtensions.newGridLayout(_function_4));
                Procedure1 _function_5 = it_2 -> it_2.setText("Fill");
                swtExtensions.newLabel((Composite)it_1, _function_5);
                Procedure1 _function_6 = it_2 -> {
                    Procedure1 _function_7 = it_3 -> {
                        it_3.horizontalSpan = 2;
                    };
                    it_2.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL(_function_7));
                };
                this.perspectiveSwitcherEdit = helper.newGradientEdit((Composite)it_1, (Procedure1<GradientEdit>)_function_6);
                Procedure1 _function_7 = it_2 -> {};
                helper.appendOrderLockButton(this.perspectiveSwitcherEdit, (Procedure1<Button>)_function_7);
                Procedure1 _function_8 = it_2 -> it_2.setText("Key Line");
                swtExtensions.newLabel((Composite)it_1, _function_8);
                Procedure1 _function_9 = it_2 -> {
                    Procedure1 _function_10 = it_3 -> {
                        it_3.horizontalSpan = 3;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_10));
                };
                this.perspectiveSwitcherKeyLineColorWell = helper.newColorWell((Composite)it_1, (Procedure1<ColorWell>)_function_9);
                Procedure1 _function_10 = it_2 -> it_2.setText("Text");
                swtExtensions.newLabel((Composite)it_1, _function_10);
                Procedure1 _function_11 = it_2 -> {
                    boolean _isWindow8 = ENVHelper.INSTANCE.isWindow8();
                    if (_isWindow8) {
                        Procedure1 _function_12 = it_3 -> {
                            it_3.horizontalSpan = 3;
                        };
                        it_2.setLayoutData((Object)swtExtensions.newGridData(_function_12));
                    }
                };
                this.perspectiveTextColorWell = helper.newColorWell((Composite)it_1, (Procedure1<ColorWell>)_function_11);
                boolean _isWindow8 = ENVHelper.INSTANCE.isWindow8();
                if (_isWindow8) {
                    Procedure1 _function_12 = it_2 -> {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Not works on Windows 8 (<a href=\"https://bugs.eclipse.org/bugs/show_bug.cgi?id=443156\">Bug 443156</a>)");
                        it_2.setText(_builder.toString());
                        Procedure1 _function_13 = it_3 -> {
                            it_3.horizontalSpan = 2;
                        };
                        it_2.setLayoutData((Object)swtExtensions.newGridData(_function_13));
                    };
                    swtExtensions.newLink((Composite)it_1, _function_12);
                }
            };
            swtExtensions.newGroup(it, _function_3);
            Procedure1 _function_4 = it_1 -> {
                it_1.setText("Window Spacing");
                it_1.setLayoutData((Object)swtExtensions.FILL_HORIZONTAL());
                Procedure1 _function_5 = it_2 -> {
                    it_2.numColumns = 3;
                };
                it_1.setLayout((Layout)swtExtensions.newGridLayout(_function_5));
                Procedure1 _function_6 = it_2 -> {
                    it_2.setText("Cast Shadow");
                    Listener _function_7 = it_3 -> {
                        this.updateRangeLabels();
                        helper.requestUpdatePreview();
                    };
                    swtExtensions.setOnSelection((Widget)it_2, _function_7);
                };
                this.castShadowEdit = swtExtensions.newCheckbox((Composite)it_1, _function_6);
                Procedure1 _function_7 = it_2 -> {
                    Procedure1 _function_8 = it_3 -> {
                        it_3.horizontalSpan = 2;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_8));
                    Listener _function_9 = it_3 -> helper.requestFastUpdatePreview();
                    swtExtensions.setOnModified((Control)it_2, _function_9);
                };
                this.shadowColorWell = helper.newColorWell((Composite)it_1, (Procedure1<ColorWell>)_function_7);
                Procedure1 _function_8 = it_2 -> it_2.setText("Part Stack Spacing");
                swtExtensions.newLabel((Composite)it_1, _function_8);
                Procedure1 _function_9 = it_2 -> {
                    it_2.setMinimum(0);
                    it_2.setMaximum(10);
                    it_2.setSelection(2);
                    Procedure1 _function_10 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_10));
                };
                this.partStackSpacingEdit = swtExtensions.newSpinner((Composite)it_1, _function_9);
                Procedure1 _function_10 = it_2 -> {
                    it_2.setText("2px ~ 10px");
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                this.partStackSpacingRangeLabel = swtExtensions.newLabel((Composite)it_1, _function_10);
                Procedure1 _function_11 = it_2 -> it_2.setText("Margins");
                swtExtensions.newLabel((Composite)it_1, _function_11);
                Procedure1 _function_12 = it_2 -> {
                    it_2.setMinimum(0);
                    it_2.setMaximum(10);
                    it_2.setSelection(4);
                    Procedure1 _function_13 = it_3 -> {
                        it_3.minimumWidth = 40;
                    };
                    it_2.setLayoutData((Object)swtExtensions.newGridData(_function_13));
                };
                this.windowMarginsEdit = swtExtensions.newSpinner((Composite)it_1, _function_12);
                Procedure1 _function_13 = it_2 -> {
                    it_2.setText("2px ~ 10px");
                    it_2.setForeground(swtExtensions.COLOR_DARK_GRAY());
                };
                this.windowMarginsRangeLabel = swtExtensions.newLabel((Composite)it_1, _function_13);
            };
            swtExtensions.newGroup(it, _function_4);
            Procedure1 _function_5 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Margins of window requires <a href=\"https://github.com/jeeeyul/eclipse-themes/wiki/Settings-that-require-opening-a-new-window\">opening new window</a> to take full effect.");
                _builder.newLine();
                it_1.setText(_builder.toString());
                Listener _function_6 = it_2 -> Program.launch((String)it_2.text);
                swtExtensions.setOnSelection((Widget)it_1, _function_6);
            };
            swtExtensions.newLink(it, _function_5);
        };
        return swtExtensions.newComposite(parent, _function);
    }

    private void updateRangeLabels() {
        boolean _selection = this.castShadowEdit.getSelection();
        if (_selection) {
            Procedures.Procedure1 _function = it -> {
                it.setMinimum(6);
                it.setSelection(Math.max(it.getSelection(), 4));
            };
            ObjectExtensions.operator_doubleArrow((Object)this.partStackSpacingEdit, (Procedures.Procedure1)_function);
            Procedures.Procedure1 _function_1 = it -> {
                it.setMinimum(4);
                it.setSelection(Math.max(it.getSelection(), 4));
            };
            ObjectExtensions.operator_doubleArrow((Object)this.windowMarginsEdit, (Procedures.Procedure1)_function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> it.setMinimum(2);
            ObjectExtensions.operator_doubleArrow((Object)this.partStackSpacingEdit, (Procedures.Procedure1)_function_2);
            Procedures.Procedure1 _function_3 = it -> it.setMinimum(0);
            ObjectExtensions.operator_doubleArrow((Object)this.windowMarginsEdit, (Procedures.Procedure1)_function_3);
        }
        StringConcatenation _builder = new StringConcatenation();
        int _minimum = this.partStackSpacingEdit.getMinimum();
        _builder.append((Object)_minimum);
        _builder.append(" ~ ");
        int _maximum = this.partStackSpacingEdit.getMaximum();
        _builder.append((Object)_maximum);
        _builder.append("px");
        this.partStackSpacingRangeLabel.setText(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        int _minimum_1 = this.windowMarginsEdit.getMinimum();
        _builder_1.append((Object)_minimum_1);
        _builder_1.append(" ~ ");
        int _maximum_1 = this.windowMarginsEdit.getMaximum();
        _builder_1.append((Object)_maximum_1);
        _builder_1.append("px");
        this.windowMarginsRangeLabel.setText(_builder_1.toString());
    }

    @Override
    public void updatePreview(CTabFolder folder, JTabSettings renderSettings, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        boolean _selection = this.castShadowEdit.getSelection();
        if (_selection) {
            Rectangle _rectangle = new Rectangle(1, 0, 4, 4);
            renderSettings.setMargins(_rectangle);
            renderSettings.setShadowColor(this.shadowColorWell.getSelection());
            Point _point = new Point(1, 1);
            renderSettings.setShadowPosition(_point);
            renderSettings.setShadowRadius(3);
        } else {
            Rectangle _rectangle_1 = new Rectangle(0, 0, 0, 0);
            renderSettings.setMargins(_rectangle_1);
            renderSettings.setShadowColor(null);
            renderSettings.setShadowRadius(0);
        }
    }

    @Override
    public void load(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        HSB psKeyline;
        Gradient psFill;
        Gradient statusBarFill;
        Gradient toolbarFill = store.getGradient("WINDOW__TOOLBAR_FILL_COLOR");
        if (toolbarFill != null) {
            this.toolbarEdit.setSelection(toolbarFill);
        }
        if ((statusBarFill = store.getGradient("WINDOW__STATUS_BAR_FILL_COLOR")) != null) {
            this.statusEdit.setSelection(statusBarFill);
        }
        this.statusTextColorWell.setSelection(store.getHSB("WINDOW__STATUS_BAR_TEXT_COLOR"));
        HSB background = store.getHSB("WINDOW__BACKGROUND_COLOR");
        if (background != null) {
            this.backgroundEdit.setSelection(background);
        }
        if ((psFill = store.getGradient("WINDOW__PERSPECTIVE_SWITCHER_FILL_COLOR")) != null) {
            this.perspectiveSwitcherEdit.setSelection(psFill);
        }
        if ((psKeyline = store.getHSB("WINDOW__PERSPECTIVE_SWITCHER_KEY_LINE_COLOR")) != null) {
            this.perspectiveSwitcherKeyLineColorWell.setSelection(psKeyline);
        }
        this.perspectiveTextColorWell.setSelection(store.getHSB("WINDOW__PERSPECTIVE_SWITCHER_TEXT_COLOR"));
        this.castShadowEdit.setSelection(store.getBoolean("LAYOUT__SHOW_SHADOW"));
        HSB shadowColor = store.getHSB("LAYOUT__SHADOW_COLOR");
        if (shadowColor != null) {
            this.shadowColorWell.setSelection(shadowColor);
        }
        this.partStackSpacingEdit.setSelection(store.getInt("WINDOW__SASH_WIDTH"));
        this.updateRangeLabels();
        this.windowMarginsEdit.setSelection(store.getRectangle((String)"WINDOW__MARGINS").x);
    }

    @Override
    public void save(JThemePreferenceStore store, @Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
        store.setValue("WINDOW__TOOLBAR_FILL_COLOR", this.toolbarEdit.getSelection());
        store.setValue("WINDOW__STATUS_BAR_FILL_COLOR", this.statusEdit.getSelection());
        store.setValue("WINDOW__STATUS_BAR_TEXT_COLOR", this.statusTextColorWell.getSelection());
        store.setValue("WINDOW__BACKGROUND_COLOR", this.backgroundEdit.getSelection());
        store.setValue("WINDOW__PERSPECTIVE_SWITCHER_FILL_COLOR", this.perspectiveSwitcherEdit.getSelection());
        store.setValue("WINDOW__PERSPECTIVE_SWITCHER_KEY_LINE_COLOR", this.perspectiveSwitcherKeyLineColorWell.getSelection());
        store.setValue("WINDOW__PERSPECTIVE_SWITCHER_TEXT_COLOR", this.perspectiveTextColorWell.getSelection());
        store.setValue("WINDOW__SASH_WIDTH", this.partStackSpacingEdit.getSelection());
        store.setValue("LAYOUT__SHOW_SHADOW", this.castShadowEdit.getSelection());
        store.setValue("LAYOUT__SHADOW_COLOR", this.shadowColorWell.getSelection());
        int windowMargin = this.windowMarginsEdit.getSelection();
        Rectangle _rectangle = new Rectangle(windowMargin, windowMargin, windowMargin, windowMargin);
        store.setValue("WINDOW__MARGINS", _rectangle);
    }

    @Override
    public void dispose(@Extension SWTExtensions swtExtensions, @Extension PreperencePageHelper helper) {
    }
}

