/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference.actions;

import java.util.Properties;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.actions.AbstractPreferenceAction;
import net.jeeeyul.eclipse.themes.ui.preference.internal.JTPreferencePage;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PropertiesUtil;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetManager;
import net.jeeeyul.swtend.SWTExtensions;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public class LoadPresetAction
extends AbstractPreferenceAction {
    private IJTPreset preset;

    public LoadPresetAction(JTPreferencePage root, IJTPreset preset) {
        super(root, preset.getName(), 32);
        this.preset = preset;
        this.setImageDescriptor(preset.getImageDescriptor());
        String lastChoosedPresetId = root.getLastChoosedPresetId();
        if (lastChoosedPresetId == null) {
            lastChoosedPresetId = root.getPreferenceStore().getString("MEMENTO__LAST_CHOOSED_PRESET");
        }
        this.setChecked(preset.getId().equals(lastChoosedPresetId));
    }

    public void run() {
        IJTPresetManager presetManager = JThemesCore.getDefault().getPresetManager();
        Properties properties = PropertiesUtil.merge(presetManager.getDefaultPreset().getProperties(), this.preset.getProperties());
        PreferenceStore store = new PreferenceStore();
        for (Object kObj : properties.keySet()) {
            String key = (String)kObj;
            String value = properties.getProperty(key);
            if (key.equals("LAYOUT__TAB_HEIGHT")) {
                int intValue = Integer.parseInt(value);
                store.setValue(key, Math.max(intValue, SWTExtensions.INSTANCE.getMinimumToolBarHeight()));
                continue;
            }
            store.setValue(key, value);
        }
        JThemePreferenceStore jtStore = new JThemePreferenceStore((IPersistentPreferenceStore)store);
        this.getPage().loadFrom(jtStore);
        this.getPage().setLastChoosedPresetId(this.preset.getId());
    }
}

