/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.preference;

import java.io.IOException;
import net.jeeeyul.eclipse.themes.ui.internal.SerializeUtil;
import net.jeeeyul.swtend.sam.Function1;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.Gradient;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class JThemePreferenceStore
implements IPreferenceStore,
IPersistentPreferenceStore {
    private IPersistentPreferenceStore originalStore;
    private SerializeUtil serializeUtil = new SerializeUtil();
    private String context = null;
    private Function1<String, String> customKeyResolver;

    JThemePreferenceStore() {
    }

    public JThemePreferenceStore(IPersistentPreferenceStore originalStore) {
        this.originalStore = originalStore;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.originalStore.addPropertyChangeListener(listener);
    }

    public boolean contains(String name) {
        return this.originalStore.contains(this.resolveKey(name));
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.originalStore.firePropertyChangeEvent(this.resolveKey(name), oldValue, newValue);
    }

    public boolean getBoolean(String name) {
        return this.originalStore.getBoolean(this.resolveKey(name));
    }

    public String getContext() {
        return this.context;
    }

    public JThemePreferenceStore getCopyWithContext(String contenxt) {
        JThemePreferenceStore result = new JThemePreferenceStore(this.originalStore);
        if (this.context == null) {
            result.setContext(contenxt);
        } else {
            result.setContext(String.valueOf(this.context) + "__" + contenxt);
        }
        return result;
    }

    public Function1<String, String> getCustomKeyResolver() {
        return this.customKeyResolver;
    }

    public boolean getDefaultBoolean(String name) {
        return this.originalStore.getDefaultBoolean(this.resolveKey(name));
    }

    public double getDefaultDouble(String name) {
        return this.originalStore.getDefaultDouble(this.resolveKey(name));
    }

    public float getDefaultFloat(String name) {
        return this.originalStore.getDefaultFloat(this.resolveKey(name));
    }

    public Gradient getDefaultGradient(String name) {
        String exp = this.originalStore.getDefaultString(this.resolveKey(name));
        if (exp == null || exp.isEmpty()) {
            return new Gradient(HSB.WHITE, HSB.WHITE);
        }
        return this.serializeUtil.deserializeGradient(exp);
    }

    public HSB getDefaultHSB(String name) {
        String exp = this.originalStore.getDefaultString(this.resolveKey(name));
        if (exp == null || exp.isEmpty()) {
            return HSB.WHITE;
        }
        return this.serializeUtil.desrializeHSB(exp);
    }

    public int getDefaultInt(String name) {
        return this.originalStore.getDefaultInt(this.resolveKey(name));
    }

    public long getDefaultLong(String name) {
        return this.originalStore.getDefaultLong(this.resolveKey(name));
    }

    public Point getDefaultPoint(String name) {
        String exp = this.originalStore.getDefaultString(this.resolveKey(name));
        if (exp == null || exp.isEmpty()) {
            return new Point(0, 0);
        }
        return this.serializeUtil.desrializePoint(exp);
    }

    public Rectangle getDefaultRectangle(String name) {
        String exp = this.originalStore.getDefaultString(this.resolveKey(name));
        if (exp == null) {
            return null;
        }
        return this.serializeUtil.desrializeRectangle(exp);
    }

    public String getDefaultString(String name) {
        return this.originalStore.getDefaultString(this.resolveKey(name));
    }

    public double getDouble(String name) {
        return this.originalStore.getDouble(this.resolveKey(name));
    }

    public float getFloat(String name) {
        return this.originalStore.getFloat(this.resolveKey(name));
    }

    public Gradient getGradient(String name) {
        String exp = this.originalStore.getString(this.resolveKey(name));
        if (exp == null || exp.isEmpty()) {
            return new Gradient(HSB.WHITE, HSB.WHITE);
        }
        return this.serializeUtil.deserializeGradient(exp);
    }

    public HSB getHSB(String name) {
        String exp = this.originalStore.getString(this.resolveKey(name));
        if (exp == null || exp.isEmpty()) {
            return HSB.RED;
        }
        return this.serializeUtil.desrializeHSB(exp);
    }

    public int getInt(String name) {
        return this.originalStore.getInt(this.resolveKey(name));
    }

    public long getLong(String name) {
        return this.originalStore.getLong(this.resolveKey(name));
    }

    public IPersistentPreferenceStore getOriginalStore() {
        return this.originalStore;
    }

    public Point getPoint(String name) {
        String exp = this.originalStore.getString(this.resolveKey(name));
        if (exp == null || exp.isEmpty()) {
            return new Point(0, 0);
        }
        return this.serializeUtil.desrializePoint(exp);
    }

    public Rectangle getRectangle(String name) {
        String exp = this.originalStore.getString(this.resolveKey(name));
        if (exp == null || exp.isEmpty()) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.serializeUtil.desrializeRectangle(exp);
    }

    public String getString(String name) {
        return this.originalStore.getString(this.resolveKey(name));
    }

    public boolean isDefault(String name) {
        return this.originalStore.isDefault(this.resolveKey(name));
    }

    public boolean needsSaving() {
        return this.originalStore.needsSaving();
    }

    public void putValue(String name, String value) {
        this.originalStore.putValue(this.resolveKey(name), value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.originalStore.removePropertyChangeListener(listener);
    }

    private String resolveKey(String name) {
        if (this.customKeyResolver != null) {
            return (String)this.customKeyResolver.apply((Object)name);
        }
        if (this.context != null) {
            return String.valueOf(this.context) + "__" + name;
        }
        return name;
    }

    public void save() {
        try {
            this.originalStore.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setCustomKeyResolver(Function1<String, String> customKeyResolver) {
        this.customKeyResolver = customKeyResolver;
    }

    public void setDefault(String name, boolean value) {
        this.originalStore.setDefault(this.resolveKey(name), value);
    }

    public void setDefault(String name, double value) {
        this.originalStore.setDefault(this.resolveKey(name), value);
    }

    public void setDefault(String name, float value) {
        this.originalStore.setDefault(this.resolveKey(name), value);
    }

    public void setDefault(String name, Gradient gradient) {
        this.originalStore.setDefault(this.resolveKey(name), this.serializeUtil.serialize(gradient));
    }

    public void setDefault(String name, HSB defaultValue) {
        this.originalStore.setDefault(this.resolveKey(name), this.serializeUtil.serialize(defaultValue));
    }

    public void setDefault(String name, int value) {
        this.originalStore.setDefault(this.resolveKey(name), value);
    }

    public void setDefault(String name, long value) {
        this.originalStore.setDefault(this.resolveKey(name), value);
    }

    public void setDefault(String name, Rectangle rect) {
        this.originalStore.setDefault(this.resolveKey(name), this.serializeUtil.serialize(rect));
    }

    public void setDefault(String name, String defaultObject) {
        this.originalStore.setDefault(this.resolveKey(name), defaultObject);
    }

    public void setDefaultValue(String name, Point point) {
        this.originalStore.setDefault(this.resolveKey(name), this.serializeUtil.serialize(point));
    }

    public void setOriginalStore(PreferenceStore originalStore) {
        this.originalStore = originalStore;
    }

    public void setToDefault(String name) {
        this.originalStore.setToDefault(this.resolveKey(name));
    }

    public void setValue(String name, boolean value) {
        this.originalStore.setValue(this.resolveKey(name), value);
    }

    public void setValue(String name, double value) {
        this.originalStore.setValue(this.resolveKey(name), value);
    }

    public void setValue(String name, float value) {
        this.originalStore.setValue(this.resolveKey(name), value);
    }

    public void setValue(String name, Gradient gradient) {
        this.originalStore.setValue(this.resolveKey(name), this.serializeUtil.serialize(gradient));
    }

    public void setValue(String name, HSB value) {
        this.originalStore.setValue(this.resolveKey(name), this.serializeUtil.serialize(value));
    }

    public void setValue(String name, int value) {
        this.originalStore.setValue(this.resolveKey(name), value);
    }

    public void setValue(String name, long value) {
        this.originalStore.setValue(this.resolveKey(name), value);
    }

    public void setValue(String name, Point point) {
        this.originalStore.setValue(this.resolveKey(name), this.serializeUtil.serialize(point));
    }

    public void setValue(String name, Rectangle rect) {
        this.originalStore.setValue(this.resolveKey(name), this.serializeUtil.serialize(rect));
    }

    public void setValue(String name, String value) {
        this.originalStore.setValue(this.resolveKey(name), value);
    }

    public void withContext(String context, Procedure1<JThemePreferenceStore> work) {
        String oldContext = this.getContext();
        this.setContext(context);
        work.apply((Object)this);
        this.setContext(oldContext);
    }
}

