/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.internal;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import net.jeeeyul.eclipse.themes.ui.hotswap.RewriteCustomTheme;
import net.jeeeyul.eclipse.themes.ui.internal.Debug;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ActiveThemeProcessor {
    EventHandler themeChangeHandler = new EventHandler(){

        public void handleEvent(Event event) {
            ActiveThemeProcessor.this.handleThemeChange(event);
        }
    };
    @Inject
    IEventBroker eventBroker;

    @PreDestroy
    public void dispose() {
        this.eventBroker.unsubscribe(this.themeChangeHandler);
        Debug.println("Active Theme Processor is disposed");
    }

    private void handleThemeChange(Event event) {
        ITheme theme = (ITheme)event.getProperty("theme");
        if (theme == null) {
            return;
        }
        boolean isCustomThemeActivated = "net.jeeeyul.eclipse.themes.custom".equals(theme.getId());
        if (isCustomThemeActivated) {
            this.onCustomThemeActivativation();
        } else {
            this.onCustomThemeDeactivation();
        }
    }

    public IThemeEngine getThemeEngine() {
        IThemeEngine engine = (IThemeEngine)Display.getDefault().getData("org.eclipse.e4.ui.css.swt.theme");
        return engine;
    }

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", this.themeChangeHandler);
        Debug.println("Active Theme Tracker has been started");
    }

    private void onCustomThemeActivativation() {
        Debug.println("Dynamic Custom Theme is Activated!");
        new RewriteCustomTheme().rewrite();
    }

    private void onCustomThemeDeactivation() {
        Debug.println("Dynamic Custom Theme is Deactivated!");
    }
}

