/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.hotswap;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.hotswap.CustomThemeGenerator;
import net.jeeeyul.eclipse.themes.ui.hotswap.HotSwap;
import net.jeeeyul.eclipse.themes.ui.internal.Debug;
import net.jeeeyul.eclipse.themes.ui.internal.ENVHelper;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class RewriteCustomTheme {
    public static final String CUSTOM_THEME_FIRST_SELECTOR = "*[class=\"jeeeyul-custom-theme\"]";
    private Display display = Display.getDefault();
    private boolean hotSwap;

    public RewriteCustomTheme() {
        this(false);
    }

    public RewriteCustomTheme(boolean hotSwap) {
        this.hotSwap = hotSwap;
    }

    private void applyTheme(String css) throws IOException {
        Debug.println("Theme is about to rewrite");
        CSSEngine cssEngine = WidgetElement.getEngine((Display)this.display);
        if (this.hotSwap) {
            HotSwap.INSTANCE.fixWindowMargins();
        }
        ExtendedDocumentCSS documentCSS = (ExtendedDocumentCSS)cssEngine.getDocumentCSS();
        StyleSheet customThemeSheet = this.findCustomThemeSheet((DocumentCSS)documentCSS);
        StyleSheet newSheet = cssEngine.parseStyleSheet((Reader)new StringReader(css));
        StyleSheetList oldSheetList = documentCSS.getStyleSheets();
        ArrayList<StyleSheet> newSheetList = new ArrayList<StyleSheet>();
        int i = 0;
        while (i < oldSheetList.getLength()) {
            StyleSheet oldSheet = oldSheetList.item(i);
            if (oldSheet != customThemeSheet) {
                if (!newSheetList.contains(oldSheet)) {
                    newSheetList.add(oldSheet);
                }
            } else if (!newSheetList.contains(newSheet)) {
                newSheetList.add(newSheet);
            }
            ++i;
        }
        documentCSS.removeAllStyleSheets();
        if (this.hotSwap && ENVHelper.INSTANCE.isLunaOrAbove()) {
            HotSwap.INSTANCE.releaseHandleImages(cssEngine);
            Debug.println("Old handle and frame images are disposed.");
        }
        for (StyleSheet each : newSheetList) {
            documentCSS.addStyleSheet(each);
        }
        cssEngine.reapply();
        Shell[] shellArray = Display.getDefault().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell each = shellArray[n2];
            each.layout(true, true);
            ++n2;
        }
        if (this.hotSwap && ENVHelper.INSTANCE.isLunaOrAbove()) {
            HotSwap.INSTANCE.fixDragHandles(cssEngine);
            Debug.println("Old handle and frame images are hot-swapped.");
        }
        Debug.println("Theme was re-written");
    }

    private StyleSheet findCustomThemeSheet(DocumentCSS documentCSS) {
        StyleSheet customThemeSheet = null;
        StyleSheetList styleSheets = documentCSS.getStyleSheets();
        int i = 0;
        block0: while (i < styleSheets.getLength()) {
            StyleSheet eachSheet = styleSheets.item(i);
            if (eachSheet instanceof CSSStyleSheet) {
                CSSRuleList cssRules = ((CSSStyleSheet)eachSheet).getCssRules();
                int j = 0;
                while (j < cssRules.getLength()) {
                    ExtendedCSSRule rule = (ExtendedCSSRule)cssRules.item(j);
                    SelectorList selectorList = rule.getSelectorList();
                    String selectorText = selectorList.item(0).toString();
                    if (CUSTOM_THEME_FIRST_SELECTOR.equals(selectorText)) {
                        customThemeSheet = eachSheet;
                        break block0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return customThemeSheet;
    }

    public void rewrite() {
        try {
            CustomThemeGenerator generator = new CustomThemeGenerator(JThemesCore.getDefault().getPreferenceStore());
            String newCSSContent = generator.generate().toString();
            this.applyTheme(newCSSContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

