/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.hotswap;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.hotswap.ResourceRegistryHack;
import net.jeeeyul.eclipse.themes.ui.internal.Debug;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.swtend.SWTExtensions;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.widgets.ImageBasedFrame;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class HotSwap {
    public static final HotSwap INSTANCE = new HotSwap();
    private HashMap<ImageBasedFrame, HashSet<Resource>> trackedFrames = new HashMap();

    private HotSwap() {
    }

    private void bind(ImageBasedFrame owner, Resource ... r) {
        HashSet<Object> hashSet = this.trackedFrames.get(owner);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.trackedFrames.put(owner, hashSet);
        }
        hashSet.addAll(Arrays.asList(r));
    }

    private void disposeBindedResources(ImageBasedFrame f) {
        HashSet<Resource> hashSet = this.trackedFrames.get(f);
        if (hashSet != null) {
            Debug.println(MessageFormat.format("Image Frame {0} disposed {1} resources", f.hashCode(), hashSet.size()));
            SWTExtensions.INSTANCE.safeDispose(hashSet);
            hashSet.clear();
        }
    }

    public void fixDragHandles(CSSEngine cssEngine) {
        Shell[] shellArray = Display.getDefault().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell each = shellArray[n2];
            Iterator iter = SWTExtensions.INSTANCE.getAllContent((Composite)each);
            while (iter.hasNext()) {
                Widget w = (Widget)iter.next();
                if (!(w instanceof ImageBasedFrame)) continue;
                this.fixHandle(cssEngine, w);
            }
            ++n2;
        }
    }

    private Image rotateImage(Display display, Image image, Integer[] frameInts) {
        if (frameInts != null) {
            int tmp = frameInts[0];
            frameInts[0] = frameInts[2];
            frameInts[2] = tmp;
            tmp = frameInts[1];
            frameInts[1] = frameInts[3];
            frameInts[3] = tmp;
        }
        Rectangle bounds = image.getBounds();
        ImageData imageData = new ImageData(bounds.height, bounds.width, 32, new PaletteData(0xFF0000, 65280, 255));
        Image rotatedImage = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)rotatedImage);
        RGB rgb = new RGB(125, 0, 0);
        Color offRed = new Color((Device)display, rgb);
        gc.setBackground(offRed);
        gc.fillRectangle(0, 0, bounds.height, bounds.width);
        Transform t = new Transform((Device)display);
        int w = image.getBounds().height;
        int offset = 0;
        t.translate((float)(w - offset), 0.0f);
        t.rotate(90.0f);
        gc.setTransform(t);
        gc.drawImage(image, 0, 0);
        gc.dispose();
        t.dispose();
        offRed.dispose();
        ImageData alphaData = rotatedImage.getImageData();
        rotatedImage.dispose();
        int transparentPix = alphaData.palette.getPixel(rgb);
        int i = 0;
        while (i < alphaData.width) {
            int j = 0;
            while (j < alphaData.height) {
                if (alphaData.getPixel(i, j) != transparentPix) {
                    alphaData.setAlpha(i, j, 255);
                }
                ++j;
            }
            ++i;
        }
        rotatedImage = new Image((Device)display, alphaData);
        return rotatedImage;
    }

    private void fixHandle(CSSEngine cssEngine, Widget w) {
        final ImageBasedFrame f = (ImageBasedFrame)w;
        if (!this.trackedFrames.containsKey(f)) {
            f.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    HotSwap.this.disposeBindedResources(f);
                    HotSwap.this.trackedFrames.remove(f);
                }
            });
        }
        Element element = cssEngine.getElement((Object)f);
        CSSStyleDeclaration style = cssEngine.getViewCSS().getComputedStyle(element, "");
        if (style != null) {
            try {
                Image handleImage;
                Control firstChild = f.getChildren()[0];
                if (!(firstChild instanceof ToolBar)) {
                    return;
                }
                ToolBar toolBar = (ToolBar)firstChild;
                boolean vertical = (toolBar.getStyle() & 0x200) != 0;
                CSSRenderingUtils util = new CSSRenderingUtils();
                Integer[] frameInts = new Integer[4];
                Image frameImage = util.createImage((Control)f, null, "frame-image", frameInts);
                if (frameImage != null && vertical) {
                    frameImage = this.rotateImage(f.getDisplay(), frameImage, frameInts);
                    this.bind(f, new Resource[]{frameImage});
                }
                if ((handleImage = util.createImage((Control)f, null, "handle-image", null)) != null && vertical) {
                    handleImage = this.rotateImage(f.getDisplay(), handleImage, null);
                    this.bind(f, new Resource[]{handleImage});
                }
                if (frameImage != null) {
                    f.setImages(frameImage, frameInts, handleImage);
                } else if (handleImage != null) {
                    f.setImages(null, null, handleImage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Rectangle windowMargins() {
        JThemePreferenceStore store = JThemesCore.getDefault().getPreferenceStore();
        Rectangle margins = store.getRectangle("WINDOW__MARGINS");
        if (store.getBoolean("LAYOUT__SHOW_SHADOW")) {
            margins.x = Math.max(margins.x - 1, 0);
            margins.width = Math.max(margins.width - 4, 0);
            margins.height = Math.max(margins.height - 4, 0);
        } else {
            margins.width = Math.max(margins.width - 1, 0);
            margins.height = Math.max(margins.height - 1, 0);
        }
        return margins;
    }

    public void fixWindowMargins() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow each = iWorkbenchWindowArray[n2];
            TrimmedPartLayout layout = (TrimmedPartLayout)each.getShell().getLayout();
            Rectangle margins = this.windowMargins();
            layout.gutterTop = margins.y;
            layout.gutterBottom = margins.height;
            layout.gutterLeft = margins.x;
            layout.gutterRight = margins.width;
            ++n2;
        }
    }

    public void releaseHandleImages(CSSEngine cssEngine) {
        IResourcesRegistry resourcesRegistry = cssEngine.getResourcesRegistry();
        new ResourceRegistryHack().disposeDynamicImages(resourcesRegistry);
    }
}

