/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui.hotswap;

import java.util.LinkedList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.themes.ITheme;

public class ColorAndFontCSSGenerator {
    private ITheme theme;
    private IThemeRegistry registry;

    public void run(StringBuilder builder) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.theme = workbench.getThemeManager().getCurrentTheme();
        this.registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        this.generateWorkbenchSettings(builder, WorkbenchPlugin.getDefault().getPreferenceStore());
        this.generateEditorSettings(builder, EditorsPlugin.getDefault().getMarkerAnnotationPreferences(), EditorsPlugin.getDefault().getPreferenceStore());
    }

    protected void generateWorkbenchSettings(StringBuilder sb, IPreferenceStore preferences) {
        String value;
        String fdString;
        String prefKey;
        ColorDefinition definition;
        LinkedList<String> keys = new LinkedList<String>();
        LinkedList<String> values = new LinkedList<String>();
        ColorDefinition[] colorDefinitionArray = this.registry.getColorsFor(this.theme.getId());
        int n = colorDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            definition = colorDefinitionArray[n2];
            if (definition.isModifiedByUser()) {
                prefKey = ThemeElementHelper.createPreferenceKey((ITheme)this.theme, (String)definition.getId());
                fdString = null;
                if (definition.getValue() != null) {
                    fdString = StringConverter.asString((RGB)definition.getValue());
                }
                if (!((value = preferences.getString(prefKey)).length() <= 0 || fdString != null && value.equals(fdString))) {
                    keys.add(prefKey);
                    values.add(value);
                }
            }
            ++n2;
        }
        colorDefinitionArray = this.registry.getFontsFor(this.theme.getId());
        n = colorDefinitionArray.length;
        n2 = 0;
        while (n2 < n) {
            definition = colorDefinitionArray[n2];
            if (definition.isModifiedByUser()) {
                prefKey = ThemeElementHelper.createPreferenceKey((ITheme)this.theme, (String)definition.getId());
                fdString = null;
                if (definition.getValue() != null) {
                    fdString = PreferenceConverter.getStoredRepresentation((FontData[])definition.getValue());
                }
                if (!((value = preferences.getString(prefKey)).length() <= 0 || fdString != null && value.equals(fdString))) {
                    keys.add(prefKey);
                    values.add(value);
                }
            }
            ++n2;
        }
        if (keys.size() > 0) {
            sb.append("IEclipsePreferences#org-eclipse-ui-workbench {\n  preferences:");
            int i = 0;
            while (i < keys.size()) {
                sb.append("\n    '").append((String)keys.get(i)).append("=").append((String)values.get(i)).append("'");
                ++i;
            }
            sb.append(";\n}\n\n");
        }
    }

    protected void generateEditorSettings(StringBuilder sb, MarkerAnnotationPreferences markerAnnotationPreferences, IPreferenceStore preferences) {
        LinkedList<String> keys = new LinkedList<String>();
        LinkedList<String> values = new LinkedList<String>();
        for (AnnotationPreference p : markerAnnotationPreferences.getAnnotationPreferences()) {
            String preferenceKey = p.getColorPreferenceKey();
            if (preferenceKey == null) continue;
            String value = preferences.getString(preferenceKey);
            RGB defaultValue = p.getColorPreferenceValue();
            if (value.length() <= 0 || defaultValue != null && value.equals(StringConverter.asString((RGB)defaultValue))) continue;
            keys.add(preferenceKey);
            values.add(value);
        }
        if (keys.size() > 0) {
            sb.append("IEclipsePreferences#org-eclipse-ui-editors {\n  preferences:");
            int i = 0;
            while (i < keys.size()) {
                sb.append("\n    '").append((String)keys.get(i)).append("=").append((String)values.get(i)).append("'");
                ++i;
            }
            sb.append(";\n}\n\n");
        }
    }
}

