/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.ui;

import java.util.Properties;
import net.jeeeyul.eclipse.themes.JThemesCore;
import net.jeeeyul.eclipse.themes.ui.hotswap.RewriteCustomTheme;
import net.jeeeyul.eclipse.themes.ui.preference.JThemePreferenceStore;
import net.jeeeyul.eclipse.themes.ui.preference.internal.PropertiesUtil;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPreset;
import net.jeeeyul.eclipse.themes.ui.preference.preset.IJTPresetManager;
import net.jeeeyul.swtend.SWTExtensions;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public class ApplyPresetAction
extends Action {
    private IJTPreset preset;

    public ApplyPresetAction(IJTPreset preset) {
        super(preset.getName(), 32);
        this.preset = preset;
        this.setImageDescriptor(preset.getImageDescriptor());
        if (this.getThemeEngine().getActiveTheme().getId().equals("net.jeeeyul.eclipse.themes.custom")) {
            String lastChoosedPresetId = this.getStore().getString("MEMENTO__LAST_CHOOSED_PRESET");
            if (preset.getId().equals(lastChoosedPresetId)) {
                this.setChecked(true);
            }
        }
    }

    public void run() {
        JThemePreferenceStore store = this.getStore();
        IJTPresetManager presetManager = JThemesCore.getDefault().getPresetManager();
        Properties properties = PropertiesUtil.merge(presetManager.getDefaultPreset().getProperties(), this.preset.getProperties());
        for (Object keyObj : properties.keySet()) {
            String key = (String)keyObj;
            String value = properties.getProperty(key);
            if (key.equals("LAYOUT__TAB_HEIGHT")) {
                int intValue = Integer.parseInt(value);
                store.setValue(key, Math.max(intValue, SWTExtensions.INSTANCE.getMinimumToolBarHeight()));
                continue;
            }
            store.setValue(key, value);
        }
        new RewriteCustomTheme(true).rewrite();
        IThemeEngine engine = this.getThemeEngine();
        if (engine.getActiveTheme() == null || !engine.getActiveTheme().getId().equals("net.jeeeyul.eclipse.themes.custom")) {
            engine.setTheme("net.jeeeyul.eclipse.themes.custom", true);
        }
        store.setValue("MEMENTO__LAST_CHOOSED_PRESET", this.preset.getId());
    }

    private IThemeEngine getThemeEngine() {
        MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        IEclipseContext context = application.getContext();
        IThemeEngine engine = (IThemeEngine)context.get(IThemeEngine.class);
        return engine;
    }

    private JThemePreferenceStore getStore() {
        JThemePreferenceStore store = JThemesCore.getDefault().getPreferenceStore();
        return store;
    }
}

