/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.optel.config.grpc;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.module.observability.configuration.KeyValueParser;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalExporterConfigurator;
import org.mule.runtime.tracer.exporter.impl.config.SpanExporterConfigurationUtils;
import org.mule.runtime.tracer.exporter.impl.optel.config.BaseSpanExporterConfigurator;
import org.mule.runtime.tracer.exporter.impl.optel.config.SpanExporterConfiguratorException;
import org.mule.runtime.tracer.exporter.impl.optel.config.http.HttpSpanExporterConfigurator;

public class GrpcSpanExporterConfigurator
extends BaseSpanExporterConfigurator {
    private static final ObservabilitySignalExporterConfigurator.TlsConfigurationMapper tlsConfigurationMapper = HttpSpanExporterConfigurator.getTlsConfigurationMapper();

    @Override
    public SpanExporter configureExporter(ObservabilitySignalConfiguration spanExporterConfiguration, MeterProvider exportMetricsMeterProvider) throws SpanExporterConfiguratorException {
        try {
            String timeout;
            String headers;
            String type;
            ObservabilitySignalExporterConfigurator exporterConfigurator = ObservabilitySignalExporterConfigurator.forConfiguration((ObservabilitySignalConfiguration)spanExporterConfiguration);
            String endpoint = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.endpoint");
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
            if (!StringUtils.isEmpty((CharSequence)endpoint)) {
                builder.setEndpoint(endpoint);
            }
            if ((type = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.compression")) != null) {
                builder.setCompression(type);
            }
            if (spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.tls.enabled", "false").equals(Boolean.TRUE.toString())) {
                exporterConfigurator.configureTlsCertificates(tlsConfigurationMapper, (tlsCaBytes, tlsCertBytes, tlsCertKeyBytes) -> this.configureTls(tlsCaBytes, tlsCertBytes, tlsCertKeyBytes, builder));
            }
            if ((headers = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.headers")) != null) {
                this.configureHeaders(builder, headers);
            }
            if ((timeout = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.timeout")) != null) {
                this.configureTimeout(builder, timeout);
            }
            SpanExporterConfigurationUtils.enableBackoffStrategy(builder, spanExporterConfiguration);
            if (SpanExporterConfigurationUtils.isHealthMetricsEnabled()) {
                builder.setInternalTelemetryVersion(InternalTelemetryVersion.LATEST);
            }
            builder.setMeterProvider(exportMetricsMeterProvider);
            return builder.build();
        }
        catch (Exception e) {
            throw new SpanExporterConfiguratorException(e);
        }
    }

    private void configureTimeout(OtlpGrpcSpanExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpGrpcSpanExporterBuilder builder, String headers) {
        KeyValueParser.parse((String)headers, (KeyValueParser.KeyValueType)KeyValueParser.KeyValueType.HEADERS).forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
    }

    private void configureTls(byte[] tlsCaBytes, byte[] tlsCertBytes, byte[] tlsCertKeyBytes, OtlpGrpcSpanExporterBuilder otlpHttpLogRecordExporterBuilder) {
        if (tlsCertBytes != null && tlsCertKeyBytes != null) {
            otlpHttpLogRecordExporterBuilder.setClientTls(tlsCertKeyBytes, tlsCertBytes);
        }
        if (tlsCaBytes != null) {
            otlpHttpLogRecordExporterBuilder.setTrustedCertificates(tlsCaBytes);
        }
    }
}

