/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.export.batch;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.tracer.exporter.impl.config.type.OpenTelemetrySpanExporterBackpressureStrategy;
import org.mule.runtime.tracer.exporter.impl.export.batch.BlockingBatchSpanProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockingBatchSpanProcessorBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BlockingBatchSpanProcessorBuilder.class);
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 1000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final SpanExporter spanExporter;
    private boolean exportUnsampledSpans = false;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(1000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private MeterProvider meterProvider = MeterProvider.noop();
    private OpenTelemetrySpanExporterBackpressureStrategy backpressureStrategy = OpenTelemetrySpanExporterBackpressureStrategy.BLOCK;

    BlockingBatchSpanProcessorBuilder(SpanExporter spanExporter) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
    }

    public BlockingBatchSpanProcessorBuilder setExportUnsampledSpans(boolean exportUnsampledSpans) {
        this.exportUnsampledSpans = exportUnsampledSpans;
        return this;
    }

    public BlockingBatchSpanProcessorBuilder setScheduleDelay(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        BlockingBatchSpanProcessorBuilder.checkArgument(delay >= 0L, "delay must be non-negative");
        this.scheduleDelayNanos = unit.toNanos(delay);
        return this;
    }

    public BlockingBatchSpanProcessorBuilder setScheduleDelay(Duration delay) {
        Objects.requireNonNull(delay, "delay");
        return this.setScheduleDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BlockingBatchSpanProcessorBuilder setExporterTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        BlockingBatchSpanProcessorBuilder.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.exporterTimeoutNanos = timeout == 0L ? Long.MAX_VALUE : unit.toNanos(timeout);
        return this;
    }

    public BlockingBatchSpanProcessorBuilder setExporterTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setExporterTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BlockingBatchSpanProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        BlockingBatchSpanProcessorBuilder.checkArgument(maxQueueSize > 0, "maxQueueSize must be positive.");
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BlockingBatchSpanProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        BlockingBatchSpanProcessorBuilder.checkArgument(maxExportBatchSize > 0, "maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public BlockingBatchSpanProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BlockingBatchSpanProcessorBuilder setBackpressureStrategy(OpenTelemetrySpanExporterBackpressureStrategy backpressureStrategy) {
        this.backpressureStrategy = backpressureStrategy;
        return this;
    }

    public BlockingBatchSpanProcessor build() {
        if (this.maxExportBatchSize > this.maxQueueSize) {
            logger.warn("maxExportBatchSize should not exceed maxQueueSize. Setting maxExportBatchSize to {} instead of {}", (Object)this.maxQueueSize, (Object)this.maxExportBatchSize);
            this.maxExportBatchSize = this.maxQueueSize;
        }
        return new BlockingBatchSpanProcessor(this.spanExporter, this.exportUnsampledSpans, this.meterProvider, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos, this.backpressureStrategy);
    }

    private static void checkArgument(boolean isValid, String errorMessage) {
        if (!isValid) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

