/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.config;

import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class SpanExporterConfigurationUtils {
    private SpanExporterConfigurationUtils() {
    }

    public static void enableBackoffStrategy(Object exporterBuilder, ObservabilitySignalConfiguration spanExporterConfiguration) {
        try {
            Field delegateField = exporterBuilder.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            Method setRetryPolicyMethod = delegateField.get(exporterBuilder).getClass().getDeclaredMethod("setRetryPolicy", RetryPolicy.class);
            setRetryPolicyMethod.setAccessible(true);
            setRetryPolicyMethod.invoke(delegateField.get(exporterBuilder), new RetryPolicyBuilder(spanExporterConfiguration).build());
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)new IllegalArgumentException("Unable to set the RetryPolicy reflectively.", e));
        }
    }

    public static boolean isHealthMetricsEnabled() {
        return Boolean.parseBoolean(System.getProperty("mule.enable.otel.exporters.health.metrics", "true"));
    }

    private static class RetryPolicyBuilder {
        private final ObservabilitySignalConfiguration spanExporterConfiguration;

        public RetryPolicyBuilder(ObservabilitySignalConfiguration spanExporterConfiguration) {
            this.spanExporterConfiguration = spanExporterConfiguration;
        }

        public RetryPolicy build() {
            return RetryPolicy.builder().setBackoffMultiplier(Double.parseDouble(this.spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.backoff.multiplier"))).setInitialBackoff(Duration.ofSeconds(Long.parseLong(this.spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.backoff.initial")))).setMaxBackoff(Duration.ofSeconds(Long.parseLong(this.spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.backoff.maximum")))).setMaxAttempts(Integer.parseInt(this.spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.backoff.maxAttempts"))).build();
        }
    }
}

