/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.UUID;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.SpanExporterFactory;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporter;
import org.mule.runtime.tracer.exporter.impl.capturer.CapturingSpanExporterWrapper;
import org.mule.runtime.tracer.exporter.impl.optel.config.OpenTelemetryAutoConfigurableSpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.impl.optel.resources.OpenTelemetryResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetrySpanExporterFactory
implements SpanExporterFactory,
Disposable,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetrySpanExporterFactory.class);
    private ObservabilitySignalConfiguration configuration;
    private ObservabilitySignalConfiguration privilegedConfiguration = new OpenTelemetryAutoConfigurableSpanExporterConfiguration(key -> null);
    private static final CapturingSpanExporterWrapper SNIFFED_EXPORTER = new CapturingSpanExporterWrapper(OpenTelemetryResources.NoOpSpanExporter.getInstance());
    private Sampler sampler;
    private FeatureFlaggingService featureFlaggingService;
    private MuleContext muleContext;
    private SpanProcessor spanProcessor;
    private MetricReader exporterMetricsReader;
    private MeterProvider exportMetricsMeterProvider = MeterProvider.noop();
    private Resource resource;
    private String artifactId;
    private String artifactType;
    private boolean addMuleAncestorSpanId;

    public OpenTelemetrySpanExporterFactory() {
    }

    protected OpenTelemetrySpanExporterFactory(ObservabilitySignalConfiguration privilegedConfiguration) {
        this.privilegedConfiguration = privilegedConfiguration;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setFeatureFlaggingService(FeatureFlaggingService featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
    }

    public org.mule.runtime.tracer.api.span.exporter.SpanExporter getSpanExporter(Span span, InitialSpanInfo initialSpanInfo) {
        return new OpenTelemetrySpanExporter(span, initialSpanInfo, this.artifactId, this.artifactType, this.spanProcessor, this.addMuleAncestorSpanId, this.resource, this.sampler);
    }

    protected SpanProcessor resolveOpenTelemetrySpanProcessor() {
        if (this.isExportEnabled()) {
            OpenTelemetrySpanExporterFactory.setPutTraceIdAndSpanIdInMdcProperty();
            return this.resolveSpanProcessor();
        }
        return SimpleSpanProcessor.create((SpanExporter)OpenTelemetryResources.NoOpSpanExporter.getInstance());
    }

    private static void setPutTraceIdAndSpanIdInMdcProperty() {
        if (System.getProperty("mule.put.trace.id.and.span.id.in.mdc") == null) {
            System.setProperty("mule.put.trace.id.and.span.id.in.mdc", Boolean.TRUE.toString());
        }
    }

    protected SpanProcessor resolveSpanProcessor() {
        if (Boolean.getBoolean("mule.openTelemetry.tracer.exporter.use.sniffer")) {
            return SimpleSpanProcessor.create((SpanExporter)SNIFFED_EXPORTER);
        }
        LOGGER.info("Mule Open Telemetry Tracer Exporter is enabled.");
        this.exporterMetricsReader = OpenTelemetryResources.resolveExporterMetricsReader(this.configuration);
        this.exportMetricsMeterProvider = OpenTelemetryResources.resolveExportMetricsMeterProvider(this.exporterMetricsReader);
        return OpenTelemetryResources.resolveOpenTelemetrySpanProcessor(this.configuration, this.privilegedConfiguration, this.resolveOpenTelemetrySpanExporter(), this.exportMetricsMeterProvider);
    }

    private boolean isExportEnabled() {
        return Boolean.parseBoolean(this.configuration.getStringValue("mule.openTelemetry.tracer.exporter.enabled"));
    }

    protected SpanExporter resolveOpenTelemetrySpanExporter() {
        return OpenTelemetryResources.resolveOpenTelemetrySpanExporter(this.configuration, this.exportMetricsMeterProvider);
    }

    public SpanSnifferManager getSpanSnifferManager() {
        return new OpenTelemetrySpanSnifferManager();
    }

    @Inject
    @Named(value="_muleSpanExporterConfiguration")
    protected void setConfiguration(ObservabilitySignalConfiguration configuration) {
        this.configuration = configuration;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.privilegedConfiguration);
        LifecycleUtils.initialiseIfNeeded((Object)this.configuration);
        this.artifactId = this.muleContext.getConfiguration().getId();
        this.artifactType = this.muleContext.getArtifactType().getAsString();
        this.resource = OpenTelemetryResources.getResource(this.artifactId, this.configuration, this.getServiceInstanceId());
        this.spanProcessor = this.resolveOpenTelemetrySpanProcessor();
        this.addMuleAncestorSpanId = this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ADD_MULE_SPECIFIC_TRACING_INFORMATION_IN_TRACE_STATE);
        this.configuration.doOnConfigurationChanged(this::doOnConfigurationChanged);
        this.sampler = this.resolveSampler();
    }

    private String getServiceInstanceId() {
        Optional deployableArtifactDescriptor = this.configuration.getDeployableArtifactDescriptor(this.muleContext.getExecutionClassLoader());
        if (deployableArtifactDescriptor.isPresent()) {
            return ((DeployableArtifactDescriptor)deployableArtifactDescriptor.get()).getDescriptorId();
        }
        LOGGER.error("Artifact descriptor not found in configuration. Auto generating Span Exporter Service Instance ID");
        return UUID.randomUUID().toString();
    }

    private void doOnConfigurationChanged() {
        SpanProcessor previousSpanProcessor = this.spanProcessor;
        MetricReader previousMetricsReader = this.exporterMetricsReader;
        this.spanProcessor = this.resolveOpenTelemetrySpanProcessor();
        OpenTelemetrySpanExporterFactory.silentlyShutdown(previousSpanProcessor);
        OpenTelemetrySpanExporterFactory.silentlyShutdown(previousMetricsReader);
    }

    private static void silentlyShutdown(SpanProcessor spanProcessor) {
        try {
            spanProcessor.shutdown();
        }
        catch (Throwable e) {
            LOGGER.warn("Error in disposing span processor", e);
        }
    }

    private static void silentlyShutdown(MetricReader metricsReader) {
        try {
            if (metricsReader != null) {
                metricsReader.shutdown();
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Error in disposing metrics reader", e);
        }
    }

    public void dispose() {
        OpenTelemetrySpanExporterFactory.silentlyShutdown(this.spanProcessor);
        OpenTelemetrySpanExporterFactory.silentlyShutdown(this.exporterMetricsReader);
        LifecycleUtils.disposeIfNeeded((Object)this.privilegedConfiguration, (Logger)LOGGER);
    }

    protected Sampler resolveSampler() {
        return OpenTelemetryResources.getSampler(this.configuration);
    }

    private static class OpenTelemetrySpanSnifferManager
    implements SpanSnifferManager {
        private OpenTelemetrySpanSnifferManager() {
        }

        public ExportedSpanSniffer getExportedSpanSniffer() {
            return SNIFFED_EXPORTER.getExportedSpanSniffer();
        }
    }
}

