/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

public final class ByteArrayHttpEntity
implements HttpEntity {
    private final byte[] content;

    public ByteArrayHttpEntity(byte[] content) {
        Objects.requireNonNull(content, "HTTP entity content cannot be null.");
        this.content = content;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public byte[] getBytes() {
        return this.content;
    }

    @Override
    public Optional<Long> getLength() {
        return Optional.of(Long.valueOf(this.content.length));
    }

    @Override
    public OptionalLong getBytesLength() {
        return OptionalLong.of(this.content.length);
    }
}

