/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.DOMWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.dw.DwShapeTypeLoader;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.json.api.JsonExampleTypeLoader;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.MuleClassLoader;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.classloader.ProjectClassPath;
import org.mule.tooling.core.classloader.ProjectClassPathProvider;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.sax.SAXUtils;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.XMLGeneratorVisitor;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.widgets.errors.ErrorDetailDialog;
import org.mule.weave.v2.el.metadata.WeaveExpressionLanguageMetadataServiceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class MetadataUtils {
    public static final MetadataKey DEFAULT_OPERATION_TYPE_KEY = ToolingMetadataKeyBuilder.newKey((String)"__default__").build();
    public static final ExpressionLanguageMetadataService EXPRESSION_LANGUAGE_SERVICE = new WeaveExpressionLanguageMetadataServiceImpl();

    private MetadataUtils() {
    }

    public static TypeLoader createTypeLoader(File file, MetadataFormat format) {
        return new DwShapeTypeLoader(file, format, EXPRESSION_LANGUAGE_SERVICE);
    }

    public static TypeLoader createTypeLoader(String content, MetadataFormat format) {
        return new DwShapeTypeLoader(content, format, EXPRESSION_LANGUAGE_SERVICE);
    }

    public static Element createElementFrom(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode node) {
        XMLGeneratorVisitor visitor = new XMLGeneratorVisitor(muleConfiguration, muleProject);
        node.accept((MessageFlowEntityVisitor)visitor);
        return MetadataUtils.asW3cElement(visitor.getResult());
    }

    private static Element asW3cElement(IElementWrapper result) {
        try {
            Document document = SAXUtils.parseXML((String)result.asXML());
            DOMWriter writer = new DOMWriter();
            org.w3c.dom.Document w3cDocument = null;
            w3cDocument = writer.write(document);
            Element w3cElement = w3cDocument.getDocumentElement();
            return MetadataUtils.findFirstElement(w3cElement.getChildNodes());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Element findFirstElement(NodeList childNodes) {
        int index = 0;
        while (index < childNodes.getLength()) {
            if (childNodes.item(index).getNodeType() == 1) {
                return (Element)childNodes.item(index);
            }
            ++index;
        }
        return null;
    }

    public static String getTypeValue(IMessageFlowNode nodeToBeTested, String typeName) {
        String propertyValue = PropertiesUtils.getPropertyValue((IMessageFlowNode)nodeToBeTested, (String)typeName);
        if (propertyValue == null) {
            List propertyCollections = nodeToBeTested.getProperties().getPropertyCollections();
            for (IReadOnlyPropertyCollection propertyCollection : propertyCollections) {
                propertyValue = PropertiesUtils.getPropertyValue((IPropertyCollectionReadCapability)propertyCollection, (String)typeName);
                if (propertyValue != null) break;
            }
        }
        return propertyValue == null ? DEFAULT_OPERATION_TYPE_KEY.getId() : propertyValue;
    }

    public static boolean isUnknown(MetadataType metadataType) {
        if (metadataType == null || MetadataFactory.isUndefined((MetadataType)metadataType)) {
            return true;
        }
        if (metadataType instanceof ArrayType) {
            MetadataType elementModel = ((ArrayType)metadataType).getType();
            return MetadataUtils.isUnknown(elementModel);
        }
        return false;
    }

    public static boolean isUnknown(Object object) {
        if (object instanceof MetadataType) {
            return MetadataUtils.isUnknown((MetadataType)object);
        }
        return false;
    }

    public static String getOperationName(IMessageFlowNode node) {
        String operationName = null;
        IServerDefinition server = MuleCorePlugin.getDesignContext().getMuleProject().getServerDefinition();
        if (CoreUtils.isCloudConnector((IMessageFlowNode)node, (IServerDefinition)server)) {
            operationName = PropertiesUtils.getPropertyValue((IMessageFlowNode)node, (String)"org.mule.tooling.ui.modules.core.widgets.meta.ModeAttribute");
        } else if (CoreUtils.getCategory((IMessageFlowNode)node) == Category.ENDPOINTS && node instanceof EndpointNode) {
            operationName = ((EndpointNode)node).getDirection().toString();
        }
        return operationName;
    }

    public static String getGlobalReferenceAttributeName(IMessageFlowNode messageFlowNode) {
        IServerDefinition server = MuleCorePlugin.getDesignContext().getMuleProject().getServerDefinition();
        String configRefAttName = "";
        configRefAttName = MetadataUtils.isNewHtml(messageFlowNode) ? MetadataUtils.getHttpConfigName(messageFlowNode) : (CoreUtils.isCloudConnector((IMessageFlowNode)messageFlowNode, (IServerDefinition)server) ? "config-ref" : "connector-ref");
        return configRefAttName;
    }

    private static String getHttpConfigName(IMessageFlowNode entity) {
        return EndpointDirection.OUTBOUND.equals((Object)((EndpointNode)entity).getDirection()) ? "config-ref-outbound" : "config-ref-inbound";
    }

    private static boolean isNewHtml(IMessageFlowNode messageFlowNode) {
        return "http://www.mulesoft.org/schema/mule/http/listener-request".equals(messageFlowNode.getType());
    }

    public static String getGlobalReference(IMessageFlowNode messageFlowNode) {
        return MetadataUtils.getGlobalReference(messageFlowNode, messageFlowNode.getProperties());
    }

    public static String getGlobalReference(IMessageFlowNode messageFlowNode, IReadOnlyPropertyCollection properties) {
        String configRefAttName = MetadataUtils.getGlobalReferenceAttributeName(messageFlowNode);
        String propertyValue = PropertiesUtils.getPropertyValue((IPropertyCollectionReadCapability)properties, (String)configRefAttName);
        return propertyValue;
    }

    public static boolean different(MetadataType expected, MetadataType actual) {
        if (expected == null && actual == null) {
            return false;
        }
        if (expected == null && actual != null) {
            return false;
        }
        if (expected != null && actual == null) {
            return true;
        }
        if (MetadataFactory.isUndefined((MetadataType)expected)) {
            return false;
        }
        return !expected.equals(actual);
    }

    public static MuleConfiguration getMuleConfigurationFor(IMuleProject muleProject, String configRefName) {
        MuleConfiguration config = null;
        List muleConfigs = muleProject.getConfigurationsCache().getConfigurations();
        for (MuleConfiguration muleConfig : muleConfigs) {
            GlobalElement retrieveGlobalElement = CoreUtils.retrieveGlobalElement((MuleConfiguration)muleConfig, (String)configRefName);
            if (retrieveGlobalElement == null) continue;
            config = muleConfig;
            break;
        }
        return config;
    }

    public static int showTestConnectionErrorMessage(String message, String stackTrace) {
        return MetadataUtils.showErrorMessage("Error in connection testing", "Test connection failed", message, stackTrace, false);
    }

    private static int showErrorMessage(String dialogTitle, String title, String message, String stackTrace, boolean showsEditCredentials) {
        Shell activeShell = Display.getDefault().getActiveShell();
        if (StringUtils.isNotBlank((String)message)) {
            title = (String)title + ": " + MetadataUtils.getFirstLine(message);
        }
        return MetadataUtils.openError(activeShell, dialogTitle, (String)title, stackTrace, StackTraceElementProvider.fromStackTrace(stackTrace), showsEditCredentials);
    }

    private static int openError(Shell activeShell, String dialogTitle, String message, String stackTrace, StackTraceElementProvider stackTraceElementProvider, boolean showsEditCredentials) {
        String reason = null;
        if (stackTrace != null) {
            reason = MetadataUtils.getFirstLine(stackTrace);
        }
        String pluginId = "org.mule.tooling.metadata";
        Status status = reason != null ? MetadataUtils.createMultiStatus(pluginId, reason, stackTraceElementProvider) : new Status(4, pluginId, message);
        return new ErrorDetailDialog(activeShell, dialogTitle, message, (IStatus)status).open();
    }

    private static String getFirstLine(String text) {
        int indexOfLineBreak = text.indexOf(10);
        return indexOfLineBreak > 0 ? text.substring(0, indexOfLineBreak) : text;
    }

    public static MultiStatus createMultiStatus(String pluginId, String reason, StackTraceElementProvider stackTraceElementProvider) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        String[] stringArray = stackTraceElementProvider.getStackTraceElement();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String stackTraceElement = stringArray[n2];
            Status status = new Status(4, pluginId, stackTraceElement);
            statuses.add(status);
            ++n2;
        }
        return new MultiStatus(pluginId, 4, (IStatus[])statuses.toArray(new Status[0]), reason, null);
    }

    public static MetadataType getMetadataFromType(Type type, ClassLoader classLoader) {
        MetadataType metadataModel = new JavaTypeLoader(classLoader).load(type);
        return metadataModel;
    }

    public static MuleClassLoader createMuleClassLoader(IMuleProject muleProject) {
        try {
            MuleClassLoader runtimeClassLoader = MuleCorePlugin.getInstance().getMuleRuntimeClassloaderCache().get(muleProject, MuleVersion.class.getClassLoader());
            ProjectClassPath projectClasspath = new ProjectClassPathProvider().getClassPath(muleProject);
            URL[] classPath = projectClasspath.getUrls();
            MuleClassLoader muleClassLoader = MuleClassLoaderUtils.createMuleClassLoader((URL[])classPath, (ClassLoader)runtimeClassLoader);
            muleClassLoader.setLibraryPaths(projectClasspath.getNativeLibraryPaths());
            return muleClassLoader;
        }
        catch (MalformedURLException e) {
            MuleCorePlugin.logError((String)"Error trying to create a project classloader", (Throwable)e);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error trying to create a project classloader", (Throwable)e);
        }
        return null;
    }

    public static boolean supportCollections(MetadataType model) {
        if (model == null || model.getMetadataFormat().equals((Object)MetadataFormat.XML)) {
            return false;
        }
        return !(model instanceof ObjectType) || !MetadataFormat.CSV.equals((Object)model.getMetadataFormat());
    }

    private static String getTypeId(MetadataType metadataType) {
        TypeIdAnnotation typeId;
        Optional typeIdAnnotation = metadataType.getAnnotation(TypeIdAnnotation.class);
        if (typeIdAnnotation.isPresent() && (typeId = (TypeIdAnnotation)typeIdAnnotation.get()) != null) {
            return typeId.getValue();
        }
        return null;
    }

    public static boolean isInteger(NumberType numberType) {
        String typeId = MetadataUtils.getTypeId((MetadataType)numberType);
        return typeId.equals("int") || typeId.equals(Integer.class.getName());
    }

    public static boolean isLong(NumberType numberType) {
        String typeId = MetadataUtils.getTypeId((MetadataType)numberType);
        return typeId.equals("long") || typeId.equals(Long.class.getName());
    }

    public static boolean isDouble(NumberType numberType) {
        String typeId = MetadataUtils.getTypeId((MetadataType)numberType);
        return typeId.equals("double") || typeId.equals(Double.class.getName());
    }

    public static String getImplementationClass(MetadataType metaDataModel) {
        return MetadataUtils.getTypeId(metaDataModel);
    }

    public static boolean isXmlMetadata(Object object) {
        if (object instanceof MetadataType) {
            MetadataType type = (MetadataType)object;
            return type.getMetadataFormat().equals((Object)MetadataFormat.XML);
        }
        return false;
    }

    public static String getSelectedFileContent(String filePath) throws FileNotFoundException, IOException {
        String result = "";
        File selectedFile = new File(filePath);
        if (selectedFile.exists() && selectedFile.canRead()) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileReader fileReader = new FileReader(selectedFile);){
                result = IOUtils.toString((Reader)fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return result;
    }

    public static MetadataType createMetadataFromJsonExample(String exampleAbsolutePath) throws FileNotFoundException, IOException {
        String exampleContent = MetadataUtils.getSelectedFileContent(exampleAbsolutePath);
        Preconditions.checkArgument((!exampleContent.isEmpty() ? 1 : 0) != 0, (Object)"Example should not be empty");
        JsonExampleTypeLoader loader = new JsonExampleTypeLoader(exampleContent);
        loader.setMergeObjectUnionTypes(true);
        Optional maybeMetadataType = loader.load(null);
        MetadataType metadataType = (MetadataType)maybeMetadataType.orElseThrow(() -> new IllegalArgumentException("The provided JSON could not be parsed as JSON Example"));
        if (metadataType instanceof AnyType) {
            throw new IllegalArgumentException("The provided JSON could not be parsed as JSON Example");
        }
        return metadataType;
    }

    private static final class DefaultStackTraceElementProvider
    implements StackTraceElementProvider {
        private String[] stackTraceElements;

        public DefaultStackTraceElementProvider(String[] stackTraceElements) {
            this.stackTraceElements = stackTraceElements;
        }

        @Override
        public String[] getStackTraceElement() {
            return this.stackTraceElements;
        }
    }

    public static interface StackTraceElementProvider {
        public String[] getStackTraceElement();

        public static StackTraceElementProvider fromStackTrace(String stackTrace) {
            return new DefaultStackTraceElementProvider(stackTrace.split("\\R"));
        }

        public static StackTraceElementProvider fromThrowable(Throwable throwable) {
            return new DefaultStackTraceElementProvider((String[])Stream.of(throwable.getStackTrace()).map(ste -> ste.toString()).toArray(String[]::new));
        }
    }
}

