/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.mule.tooling.core.classloader.MuleClassLoader;

public class CompositeClassLoader
extends ClassLoader {
    private Collection<ClassLoader> loaders;

    public CompositeClassLoader(ClassLoader ... loaders) {
        this.loaders = Arrays.asList(loaders);
    }

    public CompositeClassLoader(Collection<ClassLoader> loaders) {
        this.loaders = loaders;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader loader : this.loaders) {
            URL resource;
            if (loader == null || (resource = loader.getResource(name)) == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader loader : this.loaders) {
            InputStream is;
            if (loader == null || (is = loader.getResourceAsStream(name)) == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader loader : this.loaders) {
            if (loader == null) continue;
            try {
                Enumeration<URL> resources = loader.getResources(name);
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    if (resource == null || urls.contains(resource)) continue;
                    urls.add(resource);
                }
            }
            catch (IOException iOException) {}
        }
        return Collections.enumeration(urls);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            if (loader == null) continue;
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    @Override
    protected String findLibrary(String libname) {
        for (ClassLoader loader : this.loaders) {
            String libraryPath;
            if (loader == null || !(loader instanceof MuleClassLoader) || (libraryPath = ((MuleClassLoader)loader).findNativeLibrary(libname)) == null) continue;
            return libraryPath;
        }
        return null;
    }
}

