/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.repository;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.metadata.types.repository.ITypesRepository;

public class DefaultTypesRepository
implements ITypesRepository {
    private final Map<MetadataKey, MetadataType> metadataTypes = new TreeMap<MetadataKey, MetadataType>(new MetadataKeyComparator());

    @Override
    public boolean hasMetadataKey(MetadataKey key) {
        return this.metadataTypes.containsKey(key);
    }

    @Override
    public Set<MetadataKey> getMetadataKeys() {
        return this.metadataTypes.keySet();
    }

    @Override
    public Map<MetadataKey, MetadataType> getTypes() {
        return this.metadataTypes;
    }

    @Override
    public void addMetadataType(MetadataKey key, MetadataType structure) {
        this.metadataTypes.put(key, structure);
    }

    @Override
    public MetadataType getMetadataType(MetadataKey key) {
        return this.metadataTypes.get(key);
    }

    @Override
    public void removeMetadataType(MetadataKey key) {
        this.metadataTypes.remove(key);
    }

    @Override
    public void clear() {
        this.metadataTypes.clear();
    }

    private static final class MetadataKeyComparator
    implements Comparator<MetadataKey> {
        private MetadataKeyComparator() {
        }

        @Override
        public int compare(MetadataKey key1, MetadataKey key2) {
            if (key1 == key2) {
                return 0;
            }
            if (key1 == null && key2 != null) {
                return -1;
            }
            if (key1 != null && key2 == null) {
                return 1;
            }
            return Objects.compare(key1.getId(), key2.getId(), Comparator.naturalOrder());
        }
    }
}

