/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.ProjectMetadataExtensionManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ClassLoaderUtils;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.Activator;
import org.mule.tooling.metadata.types.model.CustomMetadataDefinition;
import org.mule.tooling.metadata.types.persistence.ICustomMetadataPersister;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class XMLCustomMetadataPersister
implements ICustomMetadataPersister {
    private static final String TRANSFORMATIONS_FOLDER = "transformations";
    private static final String PAYLOAD_VAR_NAME = "payload";
    private static final String CATALOGS_ID_VAR_NAME = "catalogs";
    private static final String ENRICHERS_ID_VAR_NAME = "enrichers";
    private static final String APPLICATION_TYPES_READER = "application-types-reader.wev";
    private static final String APPLICATION_TYPES_GENERATOR = "application-types-generator.wev";
    private static DataWeaveScript loadCustomMetadataScript;
    private static DataWeaveScript storeCustomMetadataScript;

    static {
        try {
            DataWeaveScriptingEngine dwEngine = new DataWeaveScriptingEngine();
            loadCustomMetadataScript = dwEngine.compile(XMLCustomMetadataPersister.getTransformationScript(APPLICATION_TYPES_READER), "transformations::application-types-reader");
            storeCustomMetadataScript = dwEngine.compile(XMLCustomMetadataPersister.getTransformationScript(APPLICATION_TYPES_GENERATOR), "transformations::application-types-generator");
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)MessageFormat.format("There was an error parsing scripts for {0}", "application-types.xml"), (Throwable)e);
        }
    }

    @Override
    public CustomMetadataDefinition read(IMuleProject project) {
        CustomMetadataDefinition customMetadataDefinition = new CustomMetadataDefinition();
        Optional<IFile> applicationTypesResource = this.getApplicationTypesFile(project);
        if (applicationTypesResource.map(resource -> resource.exists() && resource.getLocation() != null).orElse(false).booleanValue()) {
            File applicationTypesFile = applicationTypesResource.get().getLocation().toFile();
            if (applicationTypesFile.exists() && loadCustomMetadataScript != null) {
                ScriptingBindings scriptingBindings = new ScriptingBindings();
                scriptingBindings.addBinding(PAYLOAD_VAR_NAME, (Object)applicationTypesFile, "application/xml");
                try {
                    ClassLoader classLoader = CustomMetadataDefinition.class.getClassLoader();
                    DataWeaveResult write = (DataWeaveResult)ClassLoaderUtils.runIn(() -> loadCustomMetadataScript.write(scriptingBindings), (ClassLoader)classLoader);
                    if (write.getContent() instanceof CustomMetadataDefinition) {
                        this.createUpdateListeners((CustomMetadataDefinition)write.getContent(), project);
                    }
                    return (CustomMetadataDefinition)write.getContent();
                }
                catch (Exception e) {
                    MuleCorePlugin.logError((String)"Error reading custom metadata definition", (Throwable)e);
                }
            } else {
                this.persist(project, customMetadataDefinition);
            }
        }
        return customMetadataDefinition;
    }

    private void createUpdateListeners(CustomMetadataDefinition customMetadataDefinition, IMuleProject project) {
        ITypesManager manager = ProjectMetadataExtensionManager.getInstance().getCurrentIProjectMetadataManager().getTypesManager(project);
        customMetadataDefinition.getCatalogs().get("default").forEach((key, definition) -> {
            if (definition.getFormat().equals((Object)MetadataTypeFormat.APPLICATION_JSON) && definition.getAdditionalInformation().get("example") != null) {
                manager.addCustomMetadataFile(definition.getAdditionalInformation().get("example"), ToolingMetadataKeyBuilder.newKey((String)key).build());
            }
        });
    }

    private Optional<IFile> getApplicationTypesFile(IMuleProject project) {
        IFile fileInResources = project.getFile(IMuleResources.APPLICATION_TYPES_PATH);
        IFile result = null;
        if (fileInResources.exists()) {
            result = fileInResources;
        } else {
            IFile fileInMuleApps = project.getMuleAppsFolder().getFile("application-types.xml");
            if (fileInMuleApps.exists()) {
                result = fileInMuleApps;
            }
        }
        return Optional.ofNullable(result);
    }

    @Override
    public void persist(IMuleProject project, CustomMetadataDefinition customMetadataDefinition) {
        if (storeCustomMetadataScript != null) {
            Optional<IFile> applicationTypesFile = this.getApplicationTypesFile(project);
            IFolder applicationTypesFolder = (IFolder)applicationTypesFile.map(IResource::getParent).orElseGet(() -> project.getFile(IMuleResources.APPLICATION_TYPES_PATH).getParent());
            if (applicationTypesFolder != null && applicationTypesFolder.exists()) {
                ScriptingBindings scriptingBindings = new ScriptingBindings();
                scriptingBindings.addBinding(CATALOGS_ID_VAR_NAME, customMetadataDefinition.getCatalogs(), "application/java");
                scriptingBindings.addBinding(ENRICHERS_ID_VAR_NAME, customMetadataDefinition.getEnrichers(), "application/java");
                try {
                    DataWeaveResult write = storeCustomMetadataScript.write(scriptingBindings);
                    InputStream content = (InputStream)write.getContent();
                    MuleResourceUtils.saveOrUpdate((IFile)applicationTypesFolder.getFile("application-types.xml"), (InputStream)content);
                }
                catch (Exception e) {
                    MuleCorePlugin.logError((String)"Error persisting custom metadata definition", (Throwable)e);
                }
            } else {
                MuleCorePlugin.logInfo((String)"Mule folder does not exists, custom types not supported for domains");
            }
        }
    }

    private static String getTransformationScript(String scriptName) {
        try {
            Enumeration entries = Activator.getDefault().getBundle().findEntries(TRANSFORMATIONS_FOLDER, "*.wev", false);
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                if (!StringUtils.endsWith((CharSequence)url.getFile(), (CharSequence)scriptName)) continue;
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream stream = url.openStream();){
                    return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Error getting script for application types", (Throwable)e);
        }
        throw new RuntimeException("The weave file " + scriptName + " was not found.");
    }
}

