/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.enricher.InputParameterEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataOperationEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataTypeRef;
import org.mule.tooling.client.metadata.enricher.OutputMessageEnricher;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.MetadataTypeConverters;
import org.mule.tooling.metadata.types.model.CustomMetadataDefinition;
import org.mule.tooling.metadata.types.model.EventEnricher;
import org.mule.tooling.metadata.types.model.MessageProcessorEnricher;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;
import org.mule.tooling.metadata.types.model.OperationEnricher;
import org.mule.tooling.metadata.types.model.OutputEnricher;
import org.mule.tooling.metadata.types.model.ParamEnricher;
import org.mule.tooling.metadata.types.model.TypeRef;
import org.mule.tooling.metadata.types.persistence.FallbackCustomMetadataPersister;
import org.mule.tooling.metadata.types.persistence.ICustomMetadataPersister;
import org.mule.tooling.metadata.types.persistence.XMLCustomMetadataPersister;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.utils.LazyValue;

public class CustomMetadataDefinitionHelper {
    private final IMuleProject project;
    private ICustomMetadataPersister customMetadataPersister;
    private LazyValue<CustomMetadataDefinition> customMetadataDefinition;

    public CustomMetadataDefinitionHelper(IMuleProject project) {
        this.project = project;
        this.initializeCustomMetadataDefinition();
    }

    private void initializeCustomMetadataDefinition() {
        try {
            this.customMetadataPersister = new XMLCustomMetadataPersister();
        }
        catch (Throwable e) {
            this.customMetadataPersister = new FallbackCustomMetadataPersister();
            MuleCorePlugin.logError((String)"Error initializing Custom Metadata Definition", (Throwable)e);
        }
        this.customMetadataDefinition = new LazyValue(() -> this.customMetadataPersister.read(this.project));
    }

    public void reload() {
        this.customMetadataDefinition = new LazyValue(() -> this.customMetadataPersister.read(this.project));
    }

    public void addType(MetadataKey key, MetadataType structure) {
        Optional formatAnnotation = structure.getAnnotation(FormatAnnotation.class);
        Optional originAnnotation = structure.getAnnotation(OriginAnnotation.class);
        FormatAnnotation format = (FormatAnnotation)formatAnnotation.orElseThrow(() -> new RuntimeException("Format annotation is not provided for metadatatype"));
        OriginAnnotation origin = (OriginAnnotation)originAnnotation.orElseThrow(() -> new RuntimeException("Origin annotation is not provided for metadatatype"));
        Optional<IMetadataTypeConverter> maybeConverter = MetadataTypeConverters.getConverter(format.getFormat(), origin.getOrigin());
        MetadataTypeDefinition metadataTypeDefinition = maybeConverter.orElseThrow(() -> new RuntimeException(MessageFormat.format("Converter not found for ({0},{1})", format, origin))).toMetadataTypeDefinition(structure);
        metadataTypeDefinition.setName(key.getId());
        Map<String, MetadataTypeDefinition> defaultCatalog = this.getDefaultCatalog();
        defaultCatalog.put(metadataTypeDefinition.getName(), metadataTypeDefinition);
    }

    public void removeType(MetadataKey key) {
        String typeRefId = key.getId();
        this.removeType(typeRefId);
    }

    public void removeType(String metadataTypeKeyId) {
        Map<String, MetadataTypeDefinition> defaultCatalog = this.getDefaultCatalog();
        defaultCatalog.remove(metadataTypeKeyId);
        Map<String, MessageProcessorEnricher> enrichers = this.getEnrichers();
        ArrayList<String> enrichersToRemove = new ArrayList<String>();
        for (Map.Entry<String, MessageProcessorEnricher> entry : enrichers.entrySet()) {
            MessageProcessorEnricher messageProcessorEnricher = entry.getValue();
            EventEnricher inputEventEnricher = messageProcessorEnricher.getInput();
            EventEnricher outputEventEnricher = messageProcessorEnricher.getOutput();
            this.updateEventEnricher(metadataTypeKeyId, inputEventEnricher);
            this.updateEventEnricher(metadataTypeKeyId, outputEventEnricher);
            this.updateOperationEnricher(metadataTypeKeyId, messageProcessorEnricher.getOperation());
            if (!messageProcessorEnricher.isEmpty()) continue;
            enrichersToRemove.add(entry.getKey());
        }
        for (String enricherId : enrichersToRemove) {
            enrichers.remove(enricherId);
        }
    }

    private Map<String, MessageProcessorEnricher> getEnrichers() {
        return ((CustomMetadataDefinition)this.customMetadataDefinition.getOrCompute()).getEnrichers();
    }

    private void updateOperationEnricher(String typeRefId, OperationEnricher operation) {
        if (operation != null) {
            OutputEnricher output = operation.getOutput();
            if (typeRefId.equals(output.getPayload().getId())) {
                output.clearPayload();
            }
            if (typeRefId.equals(output.getAttributes().getId())) {
                output.clearAttributes();
            }
            List<ParamEnricher> params = operation.getParams().stream().filter(param -> !typeRefId.equals(param.getTypeRef().getId())).collect(Collectors.toList());
            operation.setParams(params);
        }
    }

    private void updateEventEnricher(String typeRefId, EventEnricher eventEnricher) {
        TypeRef attributesRef;
        TypeRef payloadRef = eventEnricher.getPayload();
        if (typeRefId.equals(payloadRef.getId())) {
            eventEnricher.clearPayload();
        }
        if (typeRefId.equals((attributesRef = eventEnricher.getAttributes()).getId())) {
            eventEnricher.clearAttributes();
        }
        ArrayList<String> variablesToRemove = new ArrayList<String>();
        Map<String, TypeRef> variables = eventEnricher.getVariables();
        for (Map.Entry<String, TypeRef> variableEnty : variables.entrySet()) {
            TypeRef variableRef = variableEnty.getValue();
            if (!typeRefId.equals(variableRef.getId())) continue;
            variablesToRemove.add(variableEnty.getKey());
        }
        for (String variableName : variablesToRemove) {
            eventEnricher.removeVariable(variableName);
        }
    }

    public void enrich(MetadataEnricher enricher) {
        Map<String, MessageProcessorEnricher> enrichers = this.getEnrichers();
        MessageProcessorEnricher messageProcessorEnricher = new MessageProcessorEnricher();
        ComponentId id = enricher.getId();
        enricher.getInputEnricher().map(this::buildEventEnricher).ifPresent(messageProcessorEnricher::setInput);
        enricher.getOutputEnricher().map(this::buildEventEnricher).ifPresent(messageProcessorEnricher::setOutput);
        enricher.getOperationEnricher().map(this::buildOperationEnricher).ifPresent(messageProcessorEnricher::setOperation);
        enrichers.put(id.toString(), messageProcessorEnricher);
    }

    public void removeEnricher(ComponentId componentId) {
        Map<String, MessageProcessorEnricher> enrichers = this.getEnrichers();
        enrichers.remove(componentId.toString());
    }

    public Optional<MetadataEnricher> getEnricher(ComponentId componentId) {
        Optional<MetadataEnricher> maybeMetadataEnricher = Optional.empty();
        Map<String, MessageProcessorEnricher> enrichers = this.getEnrichers();
        MessageProcessorEnricher messageProcessorEnricher = enrichers.get(componentId.toString());
        if (messageProcessorEnricher != null) {
            MetadataEventEnricher inputEnricher = this.buildMetadataEnricher(messageProcessorEnricher.getInput());
            MetadataEventEnricher outputEnricher = this.buildMetadataEnricher(messageProcessorEnricher.getOutput());
            MetadataOperationEnricher operationEnricher = this.toMetadataOperationEnricher(messageProcessorEnricher.getOperation());
            maybeMetadataEnricher = Optional.of(new MetadataEnricher(componentId, inputEnricher, outputEnricher, operationEnricher));
        }
        return maybeMetadataEnricher;
    }

    private MetadataOperationEnricher toMetadataOperationEnricher(OperationEnricher operation) {
        MetadataOperationEnricher result = new MetadataOperationEnricher();
        if (operation != null) {
            result.setOutput(this.toOputputOperation(operation.getOutput()));
            result.setInputs(operation.getParams().stream().map(this::toInputParameterEnricher).collect(Collectors.toList()));
        }
        return result;
    }

    private InputParameterEnricher toInputParameterEnricher(ParamEnricher param) {
        InputParameterEnricher result = new InputParameterEnricher();
        result.setName(param.getName());
        result.setTypeRef(this.toMetadataTypeRef(param.getTypeRef()));
        return result;
    }

    private OutputMessageEnricher toOputputOperation(OutputEnricher output) {
        OutputMessageEnricher result = new OutputMessageEnricher();
        result.setAttribues(this.toMetadataTypeRef(output.getAttributes()));
        result.setPayload(this.toMetadataTypeRef(output.getPayload()));
        return result;
    }

    public void persistCustomTypes() {
        this.customMetadataPersister.persist(this.project, (CustomMetadataDefinition)this.customMetadataDefinition.getOrCompute());
    }

    public void persist() {
        this.customMetadataPersister.persist(this.project, (CustomMetadataDefinition)this.customMetadataDefinition.getOrCompute());
    }

    public void clear() {
        this.customMetadataDefinition = new LazyValue(CustomMetadataDefinition::new);
    }

    public Map<String, MetadataTypeDefinition> getDefaultCatalog() {
        return ((CustomMetadataDefinition)this.customMetadataDefinition.getOrCompute()).getCatalogs().get("default");
    }

    private OperationEnricher buildOperationEnricher(MetadataOperationEnricher operationEnricher) {
        OperationEnricher result = new OperationEnricher();
        OutputMessageEnricher output = operationEnricher.getOutput();
        result.setOutput(this.toOutputEnricher(output));
        List inputs = operationEnricher.getInputs();
        result.setParams(inputs.stream().map(this::toParamEnricher).collect(Collectors.toList()));
        return result;
    }

    private ParamEnricher toParamEnricher(InputParameterEnricher param) {
        ParamEnricher result = new ParamEnricher();
        result.setName(param.getName());
        result.setTypeRef(this.toTypeRef(param.getTypeRef()));
        return result;
    }

    public OutputEnricher toOutputEnricher(OutputMessageEnricher output) {
        OutputEnricher outputEnricher = new OutputEnricher();
        if (output != null) {
            outputEnricher.setAttributes(this.toTypeRef(output.getAttribues()));
            outputEnricher.setPayload(this.toTypeRef(output.getPayload()));
        }
        return outputEnricher;
    }

    private EventEnricher buildEventEnricher(MetadataEventEnricher metadataEventEnricher) {
        EventEnricher eventEnricher = new EventEnricher();
        MetadataTypeRef payloadMetadataTypeRef = metadataEventEnricher.getPayload();
        MetadataTypeRef attributesMetadataTypeRef = metadataEventEnricher.getAttributes();
        Map variablesRef = metadataEventEnricher.getVariables();
        eventEnricher.setPayload(this.toTypeRef(payloadMetadataTypeRef));
        eventEnricher.setAttributes(this.toTypeRef(attributesMetadataTypeRef));
        for (Map.Entry entry : variablesRef.entrySet()) {
            MetadataTypeRef variableMetadataTypeRef = (MetadataTypeRef)entry.getValue();
            TypeRef variableTypeRef = new TypeRef();
            if (!variableMetadataTypeRef.isNull()) {
                variableTypeRef.setId(variableMetadataTypeRef.getKey());
                variableTypeRef.setCollection(variableMetadataTypeRef.isCollection());
            }
            eventEnricher.getVariables().put((String)entry.getKey(), variableTypeRef);
        }
        return eventEnricher;
    }

    public TypeRef toTypeRef(MetadataTypeRef attributesMetadataTypeRef) {
        TypeRef attributesTypeRef = new TypeRef();
        if (!attributesMetadataTypeRef.isNull()) {
            attributesTypeRef.setId(attributesMetadataTypeRef.getKey());
            attributesTypeRef.setCollection(attributesMetadataTypeRef.isCollection());
        }
        return attributesTypeRef;
    }

    private MetadataEventEnricher buildMetadataEnricher(EventEnricher eventEnricher) {
        MetadataEventEnricher metadataEventEnricher = new MetadataEventEnricher();
        metadataEventEnricher.setPayload(this.toMetadataTypeRef(eventEnricher.getPayload()));
        metadataEventEnricher.setAttributes(this.toMetadataTypeRef(eventEnricher.getAttributes()));
        for (Map.Entry<String, TypeRef> entry : eventEnricher.getVariables().entrySet()) {
            MetadataTypeRef.MetadataTypeRefBuilder variableRefBuilder = MetadataTypeRef.builder();
            variableRefBuilder = variableRefBuilder.withKey(entry.getValue().getId());
            if (entry.getValue().isCollection()) {
                variableRefBuilder = variableRefBuilder.asCollection();
            }
            metadataEventEnricher.addVariable(entry.getKey(), variableRefBuilder.build());
        }
        return metadataEventEnricher;
    }

    public MetadataTypeRef toMetadataTypeRef(TypeRef payload) {
        MetadataTypeRef.MetadataTypeRefBuilder payloadRefBuilder = MetadataTypeRef.builder();
        payloadRefBuilder = payloadRefBuilder.withKey(payload.getId());
        if (payload.isCollection()) {
            payloadRefBuilder = payloadRefBuilder.asCollection();
        }
        MetadataTypeRef ref = payloadRefBuilder.build();
        return ref;
    }
}

