/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;
import org.mule.tooling.metadata.utils.MetadataUtils;

public class XmlWeaveMetadataTypeConverter
implements IMetadataTypeConverter {
    @Override
    public MetadataType toMetadataType(IMuleProject project, MetadataTypeDefinition metadataTypeDefinition) {
        LinkedHashMap<Class, CustomTypeAnnotation> annotations = new LinkedHashMap<Class, CustomTypeAnnotation>();
        Map<String, String> additionalInformation = metadataTypeDefinition.getAdditionalInformation();
        String autogeneratedOrigin = additionalInformation.get("autogeneratedOrigin");
        String content = metadataTypeDefinition.getContent();
        String location = additionalInformation.get("location");
        TypeLoader loader = MetadataUtils.createTypeLoader(content, MetadataFormats.XML);
        Optional maybeMetadataType = loader.load(metadataTypeDefinition.getName());
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeDefinition.getFormat()));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(metadataTypeDefinition.getOrigin()));
        annotations.put(ElementAnnotation.class, new ElementAnnotation(additionalInformation.get("element")));
        annotations.put(PathAnnotation.class, new PathAnnotation(location));
        if (!StringUtils.isEmpty((String)content)) {
            annotations.put(ContentAnnotation.class, new ContentAnnotation(content));
        }
        if (!StringUtils.isEmpty((String)autogeneratedOrigin)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(autogeneratedOrigin));
        }
        return MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormats.XML)), annotations);
    }

    @Override
    public MetadataTypeDefinition toMetadataTypeDefinition(MetadataType structure) {
        MetadataTypeDefinition metadataTypeDefinition = new MetadataTypeDefinition();
        structure.getAnnotation(FormatAnnotation.class).ifPresent(value -> metadataTypeDefinition.setFormat(value.getFormat()));
        structure.getAnnotation(OriginAnnotation.class).ifPresent(value -> metadataTypeDefinition.setOrigin(value.getOrigin()));
        structure.getAnnotation(ContentAnnotation.class).ifPresent(value -> metadataTypeDefinition.setContent(value.getContent()));
        LinkedHashMap<String, String> additionalInformation = new LinkedHashMap<String, String>();
        structure.getAnnotation(PathAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("location", value.getPath());
        });
        structure.getAnnotation(ElementAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("element", value.getElement());
        });
        structure.getAnnotation(AutogeneratedAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("autogeneratedOrigin", value.getAutogeneratedOrigin());
        });
        metadataTypeDefinition.setAdditionalInformation(additionalInformation);
        return metadataTypeDefinition;
    }
}

