/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.ModelFactory;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;

public class XmlExampleMetadataTypeConverter
implements IMetadataTypeConverter {
    @Override
    public MetadataType toMetadataType(IMuleProject project, MetadataTypeDefinition metadataTypeDefinition) {
        LinkedHashMap<Class, CustomTypeAnnotation> annotations = new LinkedHashMap<Class, CustomTypeAnnotation>();
        String content = metadataTypeDefinition.getContent();
        Map<String, String> additionalInformation = metadataTypeDefinition.getAdditionalInformation();
        String autogeneratedOrigin = additionalInformation.get("autogeneratedOrigin");
        String location = additionalInformation.get("location");
        String element = additionalInformation.get("element");
        Optional maybeResource = CoreUtils.getResource((String)location, (IMuleProject)project);
        if (location != null) {
            annotations.put(PathAnnotation.class, new PathAnnotation(location));
        } else if (content != null) {
            annotations.put(ContentAnnotation.class, new ContentAnnotation(content));
        }
        XmlTypeLoader loader = null;
        Optional maybeMetadataType = Optional.empty();
        if (maybeResource.isPresent()) {
            File file = ((IFile)maybeResource.get()).getRawLocation().toFile();
            if (file.exists()) {
                ModelFactory modelFactory = ModelFactory.fromExample((File)file);
                loader = new XmlTypeLoader(modelFactory);
                maybeMetadataType = loader.load(element);
            }
        } else if (StringUtils.isNotEmpty((String)content)) {
            ModelFactory modelFactory = ModelFactory.fromExample((String)content);
            loader = new XmlTypeLoader(modelFactory);
            maybeMetadataType = loader.load(element);
        }
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeDefinition.getFormat()));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(metadataTypeDefinition.getOrigin()));
        annotations.put(ElementAnnotation.class, new ElementAnnotation(element));
        if (!StringUtils.isEmpty((String)autogeneratedOrigin)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(autogeneratedOrigin));
        }
        return MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormats.XML)), annotations);
    }

    @Override
    public MetadataTypeDefinition toMetadataTypeDefinition(MetadataType structure) {
        Optional maybeFormatAnnotation = structure.getAnnotation(FormatAnnotation.class);
        Optional maybeOriginAnnotation = structure.getAnnotation(OriginAnnotation.class);
        Optional maybePathAnnotation = structure.getAnnotation(PathAnnotation.class);
        Optional maybeElementAnnotation = structure.getAnnotation(ElementAnnotation.class);
        MetadataTypeDefinition metadataTypeDefinition = new MetadataTypeDefinition();
        if (maybeFormatAnnotation.isPresent()) {
            metadataTypeDefinition.setFormat(((FormatAnnotation)maybeFormatAnnotation.get()).getFormat());
        }
        if (maybeOriginAnnotation.isPresent()) {
            metadataTypeDefinition.setOrigin(((OriginAnnotation)maybeOriginAnnotation.get()).getOrigin());
        }
        LinkedHashMap<String, String> additionalInformation = new LinkedHashMap<String, String>();
        if (maybePathAnnotation.isPresent()) {
            additionalInformation.put("location", ((PathAnnotation)maybePathAnnotation.get()).getPath());
        }
        additionalInformation.put("element", ((ElementAnnotation)maybeElementAnnotation.get()).getElement());
        structure.getAnnotation(AutogeneratedAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("autogeneratedOrigin", value.getAutogeneratedOrigin());
        });
        metadataTypeDefinition.setAdditionalInformation(additionalInformation);
        return metadataTypeDefinition;
    }
}

