/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;

public class ObjectWeaveMetadataTypeConverter
implements IMetadataTypeConverter {
    @Override
    public MetadataType toMetadataType(IMuleProject project, MetadataTypeDefinition metadataTypeDefinition) {
        LinkedHashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation> annotations = new LinkedHashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation>();
        Map<String, String> additionalInformation = metadataTypeDefinition.getAdditionalInformation();
        String autogeneratedOrigin = additionalInformation.get("autogeneratedOrigin");
        String examplePath = additionalInformation.get("example");
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeDefinition.getFormat()));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(metadataTypeDefinition.getOrigin()));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(metadataTypeDefinition.getContent()));
        if (!StringUtils.isEmpty((String)examplePath)) {
            annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(examplePath));
        }
        if (!StringUtils.isEmpty((String)autogeneratedOrigin)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(autogeneratedOrigin));
        }
        return MetadataTypeProxy.proxying((MetadataType)MetadataFactory.newUndefined((MetadataFormat)MetadataFormats.JAVA), annotations);
    }

    @Override
    public MetadataTypeDefinition toMetadataTypeDefinition(MetadataType structure) {
        MetadataTypeDefinition metadataTypeDefinition = new MetadataTypeDefinition();
        LinkedHashMap<String, String> additionalInformation = new LinkedHashMap<String, String>();
        structure.getAnnotation(FormatAnnotation.class).ifPresent(value -> metadataTypeDefinition.setFormat(value.getFormat()));
        structure.getAnnotation(OriginAnnotation.class).ifPresent(value -> metadataTypeDefinition.setOrigin(value.getOrigin()));
        structure.getAnnotation(ContentAnnotation.class).ifPresent(value -> metadataTypeDefinition.setContent(value.getContent()));
        structure.getAnnotation(ExamplePathAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("example", value.getPath());
        });
        structure.getAnnotation(AutogeneratedAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("autogeneratedOrigin", value.getAutogeneratedOrigin());
        });
        metadataTypeDefinition.setAdditionalInformation(additionalInformation);
        return metadataTypeDefinition;
    }
}

