/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.classloader.ProjectClassPath;
import org.mule.tooling.core.classloader.ProjectClassPathProvider;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;

public class ObjectSchemaMetadataTypeConverter
implements IMetadataTypeConverter {
    @Override
    public MetadataType toMetadataType(IMuleProject project, MetadataTypeDefinition metadataTypeDefinition) {
        LinkedHashMap<Class, CustomTypeAnnotation> annotations = new LinkedHashMap<Class, CustomTypeAnnotation>();
        Map<String, String> additionalInformation = metadataTypeDefinition.getAdditionalInformation();
        String autogeneratedOrigin = additionalInformation.get("autogeneratedOrigin");
        String element = additionalInformation.get("element");
        Optional<ClassLoader> maybeClassloader = this.getClassloader(project);
        Optional maybeMetadataType = Optional.empty();
        if (maybeClassloader.isPresent()) {
            JavaTypeLoader loader = new JavaTypeLoader(maybeClassloader.get());
            maybeMetadataType = loader.load(element);
        }
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeDefinition.getFormat()));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(metadataTypeDefinition.getOrigin()));
        annotations.put(ElementAnnotation.class, new ElementAnnotation(element));
        if (!StringUtils.isEmpty((String)autogeneratedOrigin)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(autogeneratedOrigin));
        }
        return MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormats.JAVA)), annotations);
    }

    @Override
    public MetadataTypeDefinition toMetadataTypeDefinition(MetadataType structure) {
        Optional maybeFormatAnnotation = structure.getAnnotation(FormatAnnotation.class);
        Optional maybeOriginAnnotation = structure.getAnnotation(OriginAnnotation.class);
        Optional maybeElementAnnotation = structure.getAnnotation(ElementAnnotation.class);
        MetadataTypeDefinition metadataTypeDefinition = new MetadataTypeDefinition();
        if (maybeFormatAnnotation.isPresent()) {
            metadataTypeDefinition.setFormat(((FormatAnnotation)maybeFormatAnnotation.get()).getFormat());
        }
        if (maybeOriginAnnotation.isPresent()) {
            metadataTypeDefinition.setOrigin(((OriginAnnotation)maybeOriginAnnotation.get()).getOrigin());
        }
        LinkedHashMap<String, String> additionalInformation = new LinkedHashMap<String, String>();
        if (maybeElementAnnotation.isPresent()) {
            additionalInformation.put("element", ((ElementAnnotation)maybeElementAnnotation.get()).getElement());
        }
        structure.getAnnotation(AutogeneratedAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("autogeneratedOrigin", value.getAutogeneratedOrigin());
        });
        metadataTypeDefinition.setAdditionalInformation(additionalInformation);
        return metadataTypeDefinition;
    }

    private Optional<ClassLoader> getClassloader(IMuleProject project) {
        try {
            ProjectClassPath classPath = new ProjectClassPathProvider().getClassPath(project);
            return Optional.ofNullable(MuleClassLoaderUtils.createMuleClassLoader((URL[])classPath.getUrls(), (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        catch (MalformedURLException | JavaModelException e) {
            MuleCorePlugin.logError((String)"Error getting classloader", (Throwable)e);
            return Optional.empty();
        }
    }
}

