/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.metadata.types.converters.CobolWeaveMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.CopybookMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.CsvRAMLMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.CsvWeaveMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.ExcelSchemaMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.FixedWidthSchemaMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.FlatFileSchemaMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.JsonExampleMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.JsonSchemaMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.JsonWeaveMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.ObjectRAMLMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.ObjectSchemaMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.ObjectWeaveMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.WeaveMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.XmlExampleMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.XmlSchemaMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.XmlWeaveMetadataTypeConverter;

public class MetadataTypeConverters {
    private static Map<MetadataTypeConverterKey, IMetadataTypeConverter> converters = new HashMap<MetadataTypeConverterKey, IMetadataTypeConverter>();

    static {
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_JAVA, MetadataTypeOrigin.RAML), new ObjectRAMLMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_JAVA, MetadataTypeOrigin.SCHEMA), new ObjectSchemaMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_JAVA, MetadataTypeOrigin.WEAVE), new ObjectWeaveMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_CSV, MetadataTypeOrigin.RAML), new CsvRAMLMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_CSV, MetadataTypeOrigin.WEAVE), new CsvWeaveMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_EXCEL, MetadataTypeOrigin.WEAVE), new ExcelSchemaMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_FIXED_WIDTH, MetadataTypeOrigin.SCHEMA), new FixedWidthSchemaMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_FLAT_FILE, MetadataTypeOrigin.SCHEMA), new FlatFileSchemaMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_COPYBOOK, MetadataTypeOrigin.SCHEMA), new CopybookMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_FIXED_WIDTH, MetadataTypeOrigin.WEAVE), new CobolWeaveMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_FLAT_FILE, MetadataTypeOrigin.WEAVE), new CobolWeaveMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_COPYBOOK, MetadataTypeOrigin.WEAVE), new CobolWeaveMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_JSON, MetadataTypeOrigin.SCHEMA), new JsonSchemaMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_JSON, MetadataTypeOrigin.EXAMPLE), new JsonExampleMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_JSON, MetadataTypeOrigin.WEAVE), new JsonWeaveMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_XML, MetadataTypeOrigin.SCHEMA), new XmlSchemaMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_XML, MetadataTypeOrigin.EXAMPLE), new XmlExampleMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_XML, MetadataTypeOrigin.WEAVE), new XmlWeaveMetadataTypeConverter());
        converters.put(new MetadataTypeConverterKey(MetadataTypeFormat.APPLICATION_WEAVE, MetadataTypeOrigin.WEAVE), new WeaveMetadataTypeConverter());
    }

    public static Optional<IMetadataTypeConverter> getConverter(MetadataTypeFormat format, MetadataTypeOrigin origin) {
        return Optional.ofNullable(converters.get(new MetadataTypeConverterKey(format, origin)));
    }

    private static final class MetadataTypeConverterKey {
        private MetadataTypeFormat format;
        private MetadataTypeOrigin origin;

        public MetadataTypeConverterKey(MetadataTypeFormat format, MetadataTypeOrigin origin) {
            this.format = format;
            this.origin = origin;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
            result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetadataTypeConverterKey other = (MetadataTypeConverterKey)obj;
            if (this.format != other.format) {
                return false;
            }
            return this.origin == other.origin;
        }
    }
}

