/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;

public class FixedWidthSchemaMetadataTypeConverter
implements IMetadataTypeConverter {
    @Override
    public MetadataType toMetadataType(IMuleProject project, MetadataTypeDefinition metadataTypeDefinition) {
        String examplePath;
        LinkedHashMap<Class, CustomTypeAnnotation> annotations = new LinkedHashMap<Class, CustomTypeAnnotation>();
        Map<String, String> additionalInformation = metadataTypeDefinition.getAdditionalInformation();
        String autogeneratedOrigin = additionalInformation.get("autogeneratedOrigin");
        String location = additionalInformation.get("location");
        String element = additionalInformation.get("element");
        Optional maybeResource = CoreUtils.getResource((String)location, (IMuleProject)project);
        Optional maybeMetadataType = Optional.empty();
        if (maybeResource.isPresent()) {
            File file = ((IFile)maybeResource.get()).getRawLocation().toFile();
            FlatfileTypeLoader loader = new FlatfileTypeLoader(file.getAbsolutePath());
            if (file.exists()) {
                maybeMetadataType = loader.load(element);
            }
        }
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeDefinition.getFormat()));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(metadataTypeDefinition.getOrigin()));
        if (location != null) {
            annotations.put(PathAnnotation.class, new PathAnnotation(location));
        }
        if ((examplePath = additionalInformation.get("example")) != null) {
            annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(examplePath));
        }
        if (element != null) {
            annotations.put(ElementAnnotation.class, new ElementAnnotation(element));
        }
        if (!StringUtils.isEmpty((String)autogeneratedOrigin)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(autogeneratedOrigin));
        }
        return MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormats.FIXED_WIDTH)), annotations);
    }

    @Override
    public MetadataTypeDefinition toMetadataTypeDefinition(MetadataType structure) {
        Optional maybeFormatAnnotation = structure.getAnnotation(FormatAnnotation.class);
        Optional maybeOriginAnnotation = structure.getAnnotation(OriginAnnotation.class);
        Optional maybePathAnnotation = structure.getAnnotation(PathAnnotation.class);
        Optional maybeExamplePathAnnotation = structure.getAnnotation(ExamplePathAnnotation.class);
        Optional maybeElementAnnotation = structure.getAnnotation(ElementAnnotation.class);
        MetadataTypeDefinition metadataTypeDefinition = new MetadataTypeDefinition();
        if (maybeFormatAnnotation.isPresent()) {
            metadataTypeDefinition.setFormat(((FormatAnnotation)maybeFormatAnnotation.get()).getFormat());
        }
        if (maybeOriginAnnotation.isPresent()) {
            metadataTypeDefinition.setOrigin(((OriginAnnotation)maybeOriginAnnotation.get()).getOrigin());
        }
        LinkedHashMap<String, String> additionalInformation = new LinkedHashMap<String, String>();
        if (maybePathAnnotation.isPresent()) {
            additionalInformation.put("location", ((PathAnnotation)maybePathAnnotation.get()).getPath().toString());
        }
        if (maybeExamplePathAnnotation.isPresent()) {
            additionalInformation.put("example", ((ExamplePathAnnotation)maybeExamplePathAnnotation.get()).getPath().toString());
        }
        if (maybeElementAnnotation.isPresent()) {
            additionalInformation.put("element", ((ElementAnnotation)maybeElementAnnotation.get()).getElement());
        }
        structure.getAnnotation(AutogeneratedAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("autogeneratedOrigin", String.valueOf(value.getAutogeneratedOrigin()));
        });
        metadataTypeDefinition.setAdditionalInformation(additionalInformation);
        return metadataTypeDefinition;
    }
}

