/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;
import org.mule.tooling.metadata.utils.MetadataUtils;

public class ExcelSchemaMetadataTypeConverter
implements IMetadataTypeConverter {
    @Override
    public MetadataType toMetadataType(IMuleProject project, MetadataTypeDefinition metadataTypeDefinition) {
        LinkedHashMap<Class, CustomTypeAnnotation> annotations = new LinkedHashMap<Class, CustomTypeAnnotation>();
        Map<String, String> additionalInformation = metadataTypeDefinition.getAdditionalInformation();
        String autogeneratedOrigin = additionalInformation.get("autogeneratedOrigin");
        String content = metadataTypeDefinition.getContent();
        TypeLoader loader = MetadataUtils.createTypeLoader(content, MetadataFormats.EXCEL);
        Optional maybeMetadataType = loader.load(metadataTypeDefinition.getName());
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeDefinition.getFormat()));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(metadataTypeDefinition.getOrigin()));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(metadataTypeDefinition.getContent()));
        if (!StringUtils.isEmpty((String)autogeneratedOrigin)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(autogeneratedOrigin));
        }
        return MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormats.EXCEL)), annotations);
    }

    @Override
    public MetadataTypeDefinition toMetadataTypeDefinition(MetadataType structure) {
        Optional maybeFormatAnnotation = structure.getAnnotation(FormatAnnotation.class);
        Optional maybeOriginAnnotation = structure.getAnnotation(OriginAnnotation.class);
        Optional maybeContentAnnotation = structure.getAnnotation(ContentAnnotation.class);
        MetadataTypeDefinition metadataTypeDefinition = new MetadataTypeDefinition();
        if (maybeFormatAnnotation.isPresent()) {
            metadataTypeDefinition.setFormat(((FormatAnnotation)maybeFormatAnnotation.get()).getFormat());
        }
        if (maybeOriginAnnotation.isPresent()) {
            metadataTypeDefinition.setOrigin(((OriginAnnotation)maybeOriginAnnotation.get()).getOrigin());
        }
        if (maybeContentAnnotation.isPresent()) {
            metadataTypeDefinition.setContent(((ContentAnnotation)maybeContentAnnotation.get()).getContent());
        }
        LinkedHashMap<String, String> additionalInformation = new LinkedHashMap<String, String>();
        structure.getAnnotation(AutogeneratedAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("autogeneratedOrigin", value.getAutogeneratedOrigin());
        });
        metadataTypeDefinition.setAdditionalInformation(additionalInformation);
        return metadataTypeDefinition;
    }
}

