/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.types.converters;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;
import org.mule.tooling.metadata.utils.MetadataUtils;

public class CobolWeaveMetadataTypeConverter
implements IMetadataTypeConverter {
    @Override
    public MetadataType toMetadataType(IMuleProject project, MetadataTypeDefinition metadataTypeDefinition) {
        LinkedHashMap<Class, CustomTypeAnnotation> annotations = new LinkedHashMap<Class, CustomTypeAnnotation>();
        Map<String, String> additionalInformation = metadataTypeDefinition.getAdditionalInformation();
        String autogeneratedOrigin = additionalInformation.get("autogeneratedOrigin");
        String content = metadataTypeDefinition.getContent();
        TypeLoader loader = MetadataUtils.createTypeLoader(content, this.getMetadataFormat(metadataTypeDefinition.getFormat()));
        Optional maybeMetadataType = loader.load(metadataTypeDefinition.getName());
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeDefinition.getFormat()));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(metadataTypeDefinition.getOrigin()));
        String examplePath = additionalInformation.get("example");
        if (!StringUtils.isEmpty((String)examplePath)) {
            annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(examplePath));
        }
        if (!StringUtils.isEmpty((String)autogeneratedOrigin)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(autogeneratedOrigin));
        }
        return MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormats.FIXED_WIDTH)), annotations);
    }

    private MetadataFormat getMetadataFormat(MetadataTypeFormat format) {
        if (format.equals((Object)MetadataTypeFormat.APPLICATION_FLAT_FILE)) {
            return MetadataFormats.FLAT_FILE;
        }
        if (format.equals((Object)MetadataTypeFormat.APPLICATION_FIXED_WIDTH)) {
            return MetadataFormats.FIXED_WIDTH;
        }
        return MetadataFormats.COPYBOOK;
    }

    @Override
    public MetadataTypeDefinition toMetadataTypeDefinition(MetadataType structure) {
        MetadataTypeDefinition metadataTypeDefinition = new MetadataTypeDefinition();
        metadataTypeDefinition.setFormat(MetadataTypeFormat.APPLICATION_JSON);
        structure.getAnnotation(OriginAnnotation.class).ifPresent(value -> metadataTypeDefinition.setOrigin(value.getOrigin()));
        structure.getAnnotation(ContentAnnotation.class).ifPresent(value -> metadataTypeDefinition.setContent(value.getContent()));
        LinkedHashMap<String, String> additionalInformation = new LinkedHashMap<String, String>();
        structure.getAnnotation(PathAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("example", value.getPath());
        });
        structure.getAnnotation(AutogeneratedAnnotation.class).ifPresent(value -> {
            String string = additionalInformation.put("autogeneratedOrigin", value.getAutogeneratedOrigin());
        });
        metadataTypeDefinition.setAdditionalInformation(additionalInformation);
        return metadataTypeDefinition;
    }
}

