/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.sample;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.meta.DesignInformation;
import org.mule.tooling.core.meta.DesignInformationUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.core.model.MuleProjectComponentManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.model.messageflow.IComponentIdProvider;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.mule.xml.schemas.XmlSchemaUtils;
import org.mule.tooling.utils.JsonUtils;
import org.mule.tooling.utils.SilentRunner;

public class MetadataSampleService
implements IMuleProjectComponent {
    private IMuleProject muleProject;
    private Map<String, Map<String, String>> sampleData;
    private IComponentIdProvider componentIdProvider;

    public MetadataSampleService(IMuleProject theProject, IComponentIdProvider componentIdProvider) {
        this.muleProject = theProject;
        this.componentIdProvider = componentIdProvider;
        this.sampleData = new HashMap<String, Map<String, String>>();
    }

    public void init() {
        DesignInformationUtils.loadFrom((IMuleProject)this.muleProject).ifPresent(designInformation -> {
            this.sampleData = designInformation.getSampleData();
        });
    }

    public void deleteSample(IMessageFlowNode node, IMetadataEventSelector selector) {
        Optional<IFile> sampleFile = this.getSampleFile(node, selector);
        sampleFile.ifPresent(file -> SilentRunner.run(() -> file.delete(true, (IProgressMonitor)new NullProgressMonitor())));
        Optional<Map<String, String>> samplesFor = this.getSamplesFor(node);
        samplesFor.ifPresent(samples -> {
            samples.remove(selector.getId());
            this.saveSamples();
        });
    }

    public SampleStatus setSample(IMessageFlowNode mpId, IMetadataEventSelector selector, String name, byte[] content) {
        Map<String, String> mpSamples;
        if (content == null) {
            content = "".getBytes();
        }
        IFile sampleFile = this.getSampleFile(name);
        SampleStatus status = this.createOrUpdateFile(sampleFile, content);
        Optional<Map<String, String>> mayBeMPSamples = this.getSamplesFor(mpId);
        if (mayBeMPSamples.isPresent()) {
            mpSamples = mayBeMPSamples.get();
        } else {
            mpSamples = new HashMap<String, String>();
            this.sampleData.put(this.getComponentId(mpId, true), mpSamples);
        }
        if (!mpSamples.containsKey(selector.getId()) || !mpSamples.get(selector.getId()).equals(name)) {
            String entryPath = (String)CoreUtils.toClasspathResource((File)sampleFile.getLocation().toFile(), (IMuleProject)this.muleProject).orElseThrow(() -> new IllegalArgumentException("resource " + String.valueOf(sampleFile) + " does not belong to a source folder of project " + String.valueOf(this.muleProject)));
            mpSamples.put(selector.getId(), entryPath);
            this.saveSamples();
        }
        return status;
    }

    private SampleStatus createOrUpdateFile(IFile sampleFile, byte[] content) {
        if (!sampleFile.exists()) {
            SilentRunner.run(() -> sampleFile.create((InputStream)new ByteArrayInputStream(content), 1, null));
            return SampleStatus.CREATED;
        }
        SilentRunner.run(() -> sampleFile.setContents((InputStream)new ByteArrayInputStream(content), 1, null));
        return SampleStatus.UPDATED;
    }

    private void saveSamples() {
        DesignInformation designInformation = new DesignInformation();
        designInformation.setSampleData(this.sampleData);
        DesignInformationUtils.saveTo((IMuleProject)this.muleProject, (DesignInformation)designInformation);
    }

    private Optional<Map<String, String>> getSamplesFor(IMessageFlowNode mpId) {
        String componentId = this.getComponentId(mpId, false);
        return Optional.ofNullable(componentId == null ? null : this.sampleData.get(componentId));
    }

    private String getComponentId(IMessageFlowNode mpId, boolean createIfMissing) {
        return this.componentIdProvider.getComponentId(mpId, createIfMissing).toString();
    }

    public Optional<byte[]> getSample(IMessageFlowNode mpId, IMetadataEventSelector selector, MetadataEvent event) {
        Optional<IFile> sampleFile = this.getSampleFile(mpId, selector);
        if (!sampleFile.isPresent()) {
            return selector.select(event).flatMap(this::getDefinedSampleIf).map(s -> s.getBytes(IMuleResources.DEFAULT_CHARSET));
        }
        try {
            return Optional.of(IOUtils.toByteArray((InputStream)sampleFile.get().getContents()));
        }
        catch (IOException | CoreException throwable) {
            return Optional.empty();
        }
    }

    public Optional<String> getDefinedSampleIf(MetadataType metadataType) {
        if (MetadataTypeOrigin.EXAMPLE.equals(metadataType.getAnnotation(OriginAnnotation.class).map(OriginAnnotation::getOrigin).orElse(null)) && metadataType.getAnnotation(ContentAnnotation.class).isPresent()) {
            return Optional.ofNullable(((ContentAnnotation)metadataType.getAnnotation(ContentAnnotation.class).get()).getContent());
        }
        if (metadataType.getAnnotation(ExamplePathAnnotation.class).isPresent()) {
            String examplePath = ((ExamplePathAnnotation)metadataType.getAnnotation(ExamplePathAnnotation.class).get()).getPath();
            Optional result = CoreUtils.fromClassPathResource((String)examplePath, (IMuleProject)this.muleProject);
            String content = (String)SilentRunner.run(() -> FileUtils.readFileToString((File)((File)result.get())), null);
            return Optional.ofNullable(content);
        }
        if (metadataType.getAnnotation(ExampleAnnotation.class).isPresent()) {
            String example = ((ExampleAnnotation)metadataType.getAnnotation(ExampleAnnotation.class).get()).getValue();
            String content = MetadataSampleService.processExample(metadataType.getMetadataFormat(), example);
            return Optional.ofNullable(content);
        }
        return Optional.empty();
    }

    public static String processExample(MetadataFormat metadataFormat, String example) {
        String sampleData;
        String unescapedData = metadataFormat.equals((Object)MetadataFormat.XML) ? StringEscapeUtils.unescapeXml((String)example) : StringEscapeUtils.unescapeJavaScript((String)example);
        try {
            sampleData = metadataFormat.equals((Object)MetadataFormat.XML) ? XmlSchemaUtils.prettyPrint((String)unescapedData) : JsonUtils.prettyPrint((String)unescapedData);
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)("Error while trying to pretty print sample data for example:\n" + unescapedData), (Throwable)e);
            sampleData = unescapedData;
        }
        return sampleData;
    }

    public boolean hasSampleDefined(IMessageFlowNode mpId, IMetadataEventSelector selector, MetadataEvent event) {
        return this.getSample(mpId, selector, event).isPresent();
    }

    public Optional<String> getFileExtension(IMessageFlowNode mpId, IMetadataEventSelector selector) {
        return this.getSampleFile(mpId, selector).map(IResource::getFileExtension);
    }

    public Optional<IFile> getSampleFile(IMessageFlowNode mpId, IMetadataEventSelector selector) {
        return this.getSamplesFor(mpId).flatMap(mpSamples -> Optional.ofNullable((String)mpSamples.get(selector.getId()))).map(this::resolveFile);
    }

    private IFile getSampleFile(String sampleFileName) {
        IFolder sampleDataFolder = this.getSampleDataFolder();
        return sampleDataFolder.getFile(sampleFileName);
    }

    public IFolder getSampleDataFolder() {
        IFolder folder = this.muleProject.getFolder("src/test/resources").getFolder("sample_data");
        if (!folder.exists()) {
            SilentRunner.run(() -> {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                return null;
            }, null);
        }
        return folder;
    }

    private IFile resolveFile(String relativePath) {
        IFile resource = this.muleProject.getFolder("src/test/resources").getFile(relativePath);
        return resource != null && resource.exists() ? resource : this.muleProject.getFile(relativePath);
    }

    public static MetadataSampleService getInstance(IMuleProject muleProject) {
        return (MetadataSampleService)MuleProjectComponentManager.getInstance().getComponent(muleProject, MetadataSampleService.class);
    }

    public static enum SampleStatus {
        CREATED,
        UPDATED;

    }
}

