/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.datasense;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.types.utils.MapObjectTypeLoader;

public class SimpleTypeMetadataTypeUtils {
    private static final String SIMPLE_TYPE_TEMPLATE = "/raml/new_simple_schema.template";
    private static final String SIMPLE_TYPE_PLACEHOLDER = "SIMPLE_TYPE_PLACEHOLDER";

    public static MetadataType buildSimpleType(String simpleType, String originDocId) {
        String simpleTypeSchemaContent = "";
        InputStream template = SimpleTypeMetadataTypeUtils.class.getResourceAsStream(SIMPLE_TYPE_TEMPLATE);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Scanner scanner = new Scanner(template);){
            simpleTypeSchemaContent = scanner.useDelimiter("\\A").next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        simpleTypeSchemaContent = simpleTypeSchemaContent.replace(SIMPLE_TYPE_PLACEHOLDER, simpleType);
        MapObjectTypeLoader loader = new MapObjectTypeLoader(simpleTypeSchemaContent);
        Optional maybeMetadataType = loader.load(null);
        HashMap<Class, CustomTypeAnnotation> annotations = new HashMap<Class, CustomTypeAnnotation>();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_JAVA));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.RAML));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(simpleTypeSchemaContent));
        if (!StringUtils.isEmpty((String)originDocId)) {
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(originDocId));
        }
        return MetadataTypeProxy.proxying((MetadataType)maybeMetadataType.orElse(MetadataFactory.newUndefined((MetadataFormat)MetadataFormat.JAVA)), annotations);
    }

    public static MetadataType buildSimpleType(String simpleType) {
        return SimpleTypeMetadataTypeUtils.buildSimpleType(simpleType, "");
    }
}

