/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.datasense;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.client.Activator;
import org.mule.tooling.client.ToolingClientFactory;
import org.mule.tooling.client.ToolingComponentDataSenseResult;
import org.mule.tooling.client.ToolingComponentPath;
import org.mule.tooling.client.ToolingDataSenseNotification;
import org.mule.tooling.client.ToolingPropagationComponentResult;
import org.mule.tooling.client.ToolingPropagationInfo;
import org.mule.tooling.client.ToolingPropagationResult;
import org.mule.tooling.client.api.ComponentDataSenseResult;
import org.mule.tooling.client.api.DataSenseToolingService;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationComponentResult;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.api.PropagationResult;
import org.mule.tooling.client.api.PropagationScope;
import org.mule.tooling.client.api.ToolingApplication;
import org.mule.tooling.client.api.ToolingClient;
import org.mule.tooling.client.api.datasense.DataSenseNotificationType;
import org.mule.tooling.client.metadata.IMetadataPropagationCache;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.datasense.DataSenseRequest;
import org.mule.tooling.metadata.datasense.DataSenseResponse;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingProjectFile;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;

public final class DataSenseJob
extends Job {
    private static final String DATA_SENSE_JOB = "Resolving metadata...";
    private static final String PROPAGATION_SCOPE = System.getProperty("tooling.propagation.scope", PropagationScope.FLOW.toString());
    private DataSenseResponse dataSenseResponse = DataSenseResponse.DEFAULT;
    private final DataSenseRequest request;

    public DataSenseResponse getDataSenseResponse() {
        return this.dataSenseResponse;
    }

    public DataSenseJob(DataSenseRequest request) {
        super(DATA_SENSE_JOB);
        this.request = request;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block25: {
            Stopwatch sw;
            block24: {
                sw = Stopwatch.createStarted();
                MulePath mulePath = this.request.getMulePath();
                IMuleProject project = this.request.getProject();
                MuleConfiguration muleConfiguration = this.request.getMuleConfiguration();
                ToolingWorkspace toolingWorkspace = ToolingWorkspace.getInstance();
                ToolingComponentPath componentPath = ToolingComponentPath.from((String)mulePath.toPath());
                try {
                    try {
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try (ToolingProject toolingProject = toolingWorkspace.install(project);){
                            Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Installing project took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
                            Optional maybeToolingProjectFile = toolingProject.getProjectFile(muleConfiguration);
                            if (!maybeToolingProjectFile.isPresent()) break block24;
                            IMuleInstance instance = ToolingManager.getInstance().getToolingInstance();
                            Optional<PropertyCollection> changes = this.request.getChanges();
                            ToolingProjectFile toolingProjectFile = (ToolingProjectFile)maybeToolingProjectFile.get();
                            if (changes.isPresent()) {
                                toolingProjectFile.updateElement(mulePath, new PropertyCollectionMap(changes.get()));
                            }
                            ToolingClient toolingClient = ToolingClientFactory.buildToolingClient((IMuleInstance)instance, (IMuleProject)project);
                            Throwable throwable2 = null;
                            Object var17_21 = null;
                            try (ToolingApplication toolingApplication = toolingClient.newToolingApplication(toolingProject);){
                                if (this.request.evictMetadata()) {
                                    toolingApplication.getMetadataToolingService().evictMetadataAt(componentPath.toPath());
                                }
                                DataSenseToolingService dataSenseToolingService = toolingApplication.getDataSenseToolingService();
                                PropagationInfo propagationInfo = this.fetchPropagationInfo(dataSenseToolingService, componentPath, this.request);
                                ComponentDataSenseResult componentDataSenseResult = this.fetchComponentDataSenseResult(dataSenseToolingService, componentPath, this.request);
                                this.dataSenseResponse = new DataSenseResponse(propagationInfo, componentDataSenseResult);
                                long totalDurationInMs = sw.elapsed(TimeUnit.MILLISECONDS);
                                Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Data Sense service replied in [%s] ms", Long.toString(totalDurationInMs)));
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        MuleCorePlugin.logError((String)"Error while resolving data sense", (Throwable)e);
                        this.dataSenseResponse = new DataSenseResponse(this.buildPropagationError(e, componentPath), this.buildComponentDataSenseError(e, componentPath));
                        Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Data Sense Job [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
                        monitor.done();
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Data Sense Job [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
                    monitor.done();
                    throw throwable;
                }
            }
            Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Data Sense Job [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private PropagationInfo fetchPropagationInfo(DataSenseToolingService dataSenseToolingService, ToolingComponentPath componentPath, DataSenseRequest request) {
        PropagationInfo propagationInfo;
        Stopwatch sw;
        block13: {
            block12: {
                sw = Stopwatch.createStarted();
                propagationInfo = ToolingPropagationInfo.PropagationInfoBuilder.DEFAULT;
                if (this.isPropagationRequired(request)) break block12;
                PropagationInfo propagationInfo2 = propagationInfo;
                Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
                return propagationInfo2;
            }
            try {
                try {
                    EditingScope scope = request.getScope();
                    IMuleProject project = request.getProject();
                    MuleConfiguration muleConfiguration = request.getMuleConfiguration();
                    long propagationLastEvictionTime = this.getMetadataPropagationCache().getLastEvictionTime(project, scope);
                    PropagationScope propagationScope = PropagationScope.valueOf((String)PROPAGATION_SCOPE);
                    PropagationResult propagationResult = switch (propagationScope) {
                        case PropagationScope.COMPONENT -> dataSenseToolingService.resolveComponentPropagation((IComponentPath)componentPath);
                        case PropagationScope.FLOW -> dataSenseToolingService.resolveFlowPropagation(componentPath.getRoot());
                        case PropagationScope.CONFIG -> dataSenseToolingService.resolveConfigPropagation(muleConfiguration.getName());
                        case PropagationScope.APPLICATION -> dataSenseToolingService.resolveApplicationPropagation();
                        default -> {
                            MuleCorePlugin.logError((String)("Unsupported propagation scope: " + String.valueOf(propagationScope)), (Throwable)new UnsupportedOperationException());
                            yield ToolingPropagationResult.PropagationResultBuilder.EMPTY;
                        }
                    };
                    PropagationComponentResult propagationComponentResult = Optional.ofNullable((PropagationComponentResult)propagationResult.getPropagationByComponentPath().get(componentPath)).orElse(ToolingPropagationComponentResult.PropagationComponentResultBuilder.EMPTY);
                    propagationInfo = new ToolingPropagationInfo.PropagationInfoBuilder().withPropagation(propagationComponentResult).withNotifications(propagationResult.getNotifcations()).withGlobalBindings(propagationResult.getGlobalBindings()).withFunctionBindings(propagationResult.getFunctionBindings()).withComponentPath(propagationComponentResult.getComponentPath()).build();
                    long propagationLatestEvictionTime = this.getMetadataPropagationCache().getLastEvictionTime(project, scope);
                    if (propagationLatestEvictionTime != propagationLastEvictionTime) break block13;
                    this.getMetadataPropagationCache().put(project, (IComponentPath)ToolingComponentPath.from((String)componentPath.getRoot()), propagationInfo, scope);
                    Map propagationByComponentPath = propagationResult.getPropagationByComponentPath();
                    for (Map.Entry entry : propagationByComponentPath.entrySet()) {
                        PropagationComponentResult value = (PropagationComponentResult)entry.getValue();
                        PropagationInfo entryPropagationInfo = new ToolingPropagationInfo.PropagationInfoBuilder().withPropagation(value).withNotifications(propagationResult.getNotifcations()).withGlobalBindings(propagationResult.getGlobalBindings()).withFunctionBindings(propagationResult.getFunctionBindings()).withComponentPath(value.getComponentPath()).build();
                        this.getMetadataPropagationCache().put(project, (IComponentPath)entry.getKey(), entryPropagationInfo, scope);
                    }
                }
                catch (Exception e) {
                    MuleCorePlugin.logError((String)"Error while resolving metadata propagation", (Throwable)e);
                    propagationInfo = this.buildPropagationError(e, componentPath);
                    Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
                }
            }
            catch (Throwable throwable) {
                Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
                throw throwable;
            }
        }
        Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
        return propagationInfo;
    }

    private ComponentDataSenseResult fetchComponentDataSenseResult(DataSenseToolingService dataSenseToolingService, ToolingComponentPath componentPath, DataSenseRequest request) {
        ComponentDataSenseResult componentDataSenseResult;
        Stopwatch sw;
        block5: {
            sw = Stopwatch.createStarted();
            componentDataSenseResult = ToolingComponentDataSenseResult.ComponentDataSenseResultBuilder.DEFAULT;
            if (this.isComponentDataSenseRequired(request)) break block5;
            ComponentDataSenseResult componentDataSenseResult2 = componentDataSenseResult;
            Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
            return componentDataSenseResult2;
        }
        try {
            try {
                componentDataSenseResult = dataSenseToolingService.resolveComponentDataSense((IComponentPath)componentPath);
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"Error while resolving component datasense", (Throwable)e);
                componentDataSenseResult = this.buildComponentDataSenseError(e, componentPath);
                Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
            }
        }
        catch (Throwable throwable) {
            Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
            throw throwable;
        }
        Activator.debugTracer().trace(Activator.DATASENSE_PERF_ID, String.format("Task took [%s] ms", sw.elapsed(TimeUnit.MILLISECONDS)));
        return componentDataSenseResult;
    }

    private IMetadataPropagationCache getMetadataPropagationCache() {
        return (IMetadataPropagationCache)MuleCorePlugin.getStudioContext().get(IMetadataPropagationCache.class);
    }

    private boolean isPropagationRequired(DataSenseRequest request) {
        DataSenseRequest.DataSenseRequestType dataSenseRequestType = request.getDataSenseRequestType();
        return DataSenseRequest.DataSenseRequestType.BOTH == dataSenseRequestType || DataSenseRequest.DataSenseRequestType.PROPAGATION == dataSenseRequestType;
    }

    private boolean isComponentDataSenseRequired(DataSenseRequest request) {
        DataSenseRequest.DataSenseRequestType dataSenseRequestType = request.getDataSenseRequestType();
        return DataSenseRequest.DataSenseRequestType.BOTH == dataSenseRequestType || DataSenseRequest.DataSenseRequestType.COMPONENT == dataSenseRequestType;
    }

    private PropagationInfo buildPropagationError(Exception e, ToolingComponentPath componentPath) {
        return new ToolingPropagationInfo.PropagationInfoBuilder().withNotifications(Collections.singletonList(new ToolingDataSenseNotification.DataSenseNotificationBuilder().withMessage(Optional.ofNullable(e.getMessage()).orElse(e.getClass().getSimpleName())).withReason(Throwables.getStackTraceAsString((Throwable)e)).withNotificationType(DataSenseNotificationType.fatalErrorDataSenseNotificationType((String)"propagation-resolution-error")).build())).withComponentPath((IComponentPath)componentPath).build();
    }

    private ComponentDataSenseResult buildComponentDataSenseError(Exception e, ToolingComponentPath componentPath) {
        return new ToolingComponentDataSenseResult.ComponentDataSenseResultBuilder().withNotifications(Collections.singletonList(new ToolingDataSenseNotification.DataSenseNotificationBuilder().withMessage(Optional.ofNullable(e.getMessage()).orElse(e.getClass().getSimpleName())).withReason(Throwables.getStackTraceAsString((Throwable)e)).withNotificationType(DataSenseNotificationType.fatalErrorDataSenseNotificationType((String)"component-datasense-resolution-error")).withComponentPath((IComponentPath)componentPath).build())).build();
    }

    public PropagationInfo joinAndGetPropagationInfo() {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logError((String)"Error while resolving metadata propagation", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return this.getDataSenseResponse().getPropagationInfo();
    }
}

