/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.HashMap;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.custom.metadata.assistant.IMetadataResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.ResultHandlerParameters;
import org.mule.tooling.metadata.custom.metadata.assistant.WeaveResultHandler;

public class XmlResultHandler
implements IMetadataResultHandler {
    public static final String XML_ROOT_ELEMENT_MARK = "#root:";
    private IMuleProject project;
    private ITypesManager typesManager;
    private String originDocId;

    public XmlResultHandler(IMuleProject project, ITypesManager typesManager, String originDocId) {
        this.project = project;
        this.typesManager = typesManager;
        this.originDocId = originDocId;
    }

    @Override
    public void generateCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        if (this.isExample(parameters.getMetadata().getAnnotations())) {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), this.generateXMLExampleCustomMetadata(parameters.getMetadata()));
        } else if (this.isSchema(parameters.getMetadata().getAnnotations())) {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), this.generateXMLSchemaCustomMetadata(parameters.getMetadata()));
        } else {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), new WeaveResultHandler(this.project, this.typesManager, this.originDocId).generateWeaveAsCustomMetadata(parameters.getMetadata(), parameters.getCustomMetadataName(), parameters.getTargetElementDocID(), parameters.getMetadataTypeFormat()));
        }
    }

    private MetadataType generateXMLExampleCustomMetadata(MetadataType metadata) {
        HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation> annotations = new HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation>();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_XML));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.EXAMPLE));
        annotations.put(PathAnnotation.class, new PathAnnotation(this.getMatchingExistingMetadataLocation(IMetadataResultHandler.getCustomMetadataName(metadata), "location")));
        annotations.put(ElementAnnotation.class, new ElementAnnotation(metadata.toString().replace(XML_ROOT_ELEMENT_MARK, "")));
        annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(this.originDocId));
        return MetadataTypeProxy.proxying((MetadataType)metadata, annotations);
    }

    private MetadataType generateXMLSchemaCustomMetadata(MetadataType metadata) {
        HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation> annotations = new HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation>();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_XML));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
        annotations.put(PathAnnotation.class, new PathAnnotation(this.getMatchingExistingMetadataLocation(IMetadataResultHandler.getCustomMetadataName(metadata), "location")));
        annotations.put(ElementAnnotation.class, new ElementAnnotation(metadata.toString().replace(XML_ROOT_ELEMENT_MARK, "")));
        annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(this.originDocId));
        return MetadataTypeProxy.proxying((MetadataType)metadata, annotations);
    }

    @Override
    public String getMatchingExistingMetadataLocation(String customMetadataName, String locationKey) {
        return this.typesManager.findCustomMetadataLocationByMetadataName(customMetadataName, locationKey);
    }
}

