/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.annotations.PropertiesAnnotation;
import org.mule.tooling.metadata.custom.metadata.assistant.IMetadataResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.ResultHandlerParameters;
import org.mule.tooling.metadata.types.utils.DataWeaveMetadataTypeWriter;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;

public class WeaveResultHandler
implements IMetadataResultHandler {
    private IMuleProject project;
    private ITypesManager typesManager;
    private String originDocId;
    public static final String WEAVE_FOLDER_PATH = "weave".concat("/").concat("autogenerated");
    public static final String FULL_WEAVE_FOLDER_PATH = "src/main/resources".concat("/").concat(WEAVE_FOLDER_PATH);
    public static final String DW_SCRIPT_SEPARATOR = System.lineSeparator() + "---" + System.lineSeparator();
    public static final String DW_SCRIPT_ERROR_MSG = "The Dataweave script generated contains errors and cannot be used to generate custom metadata";

    public WeaveResultHandler(IMuleProject project, ITypesManager typesManager, String originDocId) {
        this.project = project;
        this.typesManager = typesManager;
        this.originDocId = originDocId;
    }

    @Override
    public void generateCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        this.addType(this.typesManager, parameters.getCustomMetadataName(), this.generateWeaveAsCustomMetadata(parameters.getMetadata(), parameters.getCustomMetadataName(), parameters.getTargetElementDocID(), parameters.getMetadataTypeFormat()));
    }

    public MetadataType generateWeaveAsCustomMetadata(MetadataType metadata, String customMetadataName, String targetElementDocID, MetadataTypeFormat metadataTypeFormat) throws IllegalArgumentException {
        HashMap<Class, CustomTypeAnnotation> annotations = new HashMap<Class, CustomTypeAnnotation>();
        String customMetadataDirectionName = StringUtils.substringAfterLast((String)customMetadataName, (String)"_");
        String dwVariableName = this.variableNameToDwVariableName(customMetadataName);
        String content = new DataWeaveMetadataTypeWriter(dwVariableName).toString(metadata);
        String folderPath = WEAVE_FOLDER_PATH.concat("/").concat(targetElementDocID);
        String fileName = customMetadataDirectionName.concat(".wev");
        String location = this.getMatchingExistingMetadataLocationByMetadata(content, dwVariableName, "example", metadataTypeFormat);
        if (StringUtils.isEmpty((String)location)) {
            location = folderPath.concat("/").concat(fileName);
        }
        if (this.usesPathAndElementAnnotation(metadataTypeFormat)) {
            annotations.put(PathAnnotation.class, new PathAnnotation(location));
            annotations.put(ElementAnnotation.class, new ElementAnnotation(customMetadataName));
            content = this.sanitizeDwTypeScript(content, this.getXmlRootElementValue(metadata));
        } else {
            annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(location));
        }
        if (!this.hasDataweaveScriptErrors(content, customMetadataName)) {
            this.persistCustomMetadataType(this.project, folderPath, content, fileName);
            annotations.put(ContentAnnotation.class, new ContentAnnotation(content));
            annotations.put(PropertiesAnnotation.class, new PropertiesAnnotation(this.getProperties(metadata)));
            annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeFormat));
            annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.WEAVE));
            annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(this.originDocId));
            return MetadataTypeProxy.proxying((MetadataType)metadata, annotations);
        }
        throw new IllegalArgumentException(DW_SCRIPT_ERROR_MSG);
    }

    private boolean usesPathAndElementAnnotation(MetadataTypeFormat metadataTypeFormat) {
        return metadataTypeFormat.equals((Object)MetadataTypeFormat.APPLICATION_XML) || metadataTypeFormat.equals((Object)MetadataTypeFormat.APPLICATION_COPYBOOK) || metadataTypeFormat.equals((Object)MetadataTypeFormat.APPLICATION_FLAT_FILE) || metadataTypeFormat.equals((Object)MetadataTypeFormat.APPLICATION_FIXED_WIDTH);
    }

    private String sanitizeDwTypeScript(String content, String root) {
        return content.replace("_".concat(root.substring(root.indexOf("{") + 1, root.indexOf("}")).replace(".", "_").concat("_")), "").replace("#root:".replace("#", "_"), "");
    }

    private String getXmlRootElementValue(MetadataType metadata) {
        if (metadata instanceof DefaultObjectType) {
            return ((DefaultObjectType)metadata).getFields().stream().filter(DefaultObjectFieldType.class::isInstance).findFirst().map(entry -> entry.getValue().toString()).orElse("");
        }
        return metadata.toString();
    }

    private Map<String, String> getProperties(MetadataType metadata) {
        return metadata.getAnnotations().stream().filter(MetadataFormatPropertiesAnnotation.class::isInstance).findFirst().map(entry -> ((MetadataFormatPropertiesAnnotation)entry).getValue()).orElse(new HashMap());
    }

    public String getMatchingExistingMetadataLocationByMetadata(String content, String dwVariableName, String locationKey, MetadataTypeFormat metadataTypeFormat) {
        return this.typesManager.findCustomMetadataLocationByMetadataFormat(content, dwVariableName, locationKey, metadataTypeFormat);
    }

    private String variableNameToDwVariableName(String variableName) {
        return variableName.replace("-", "_");
    }

    private String addVariableNameToDwScript(String dwScript, String customMetadataName) {
        return dwScript.concat(DW_SCRIPT_SEPARATOR).concat(this.variableNameToDwVariableName(customMetadataName)).concat(System.lineSeparator());
    }

    private boolean hasDataweaveScriptErrors(String dwScript, String customMetadataName) {
        List dwErrors = WeaveEngineHelperManager.execute((String)this.addVariableNameToDwScript(dwScript, customMetadataName), (IMuleProject)this.project).getErrors();
        if (!dwErrors.isEmpty()) {
            dwErrors.forEach(e -> {
                String error = e.getMessage().isPresent() ? (String)e.getMessage().get() : "";
                MuleCorePlugin.logError((String)("It was not possible to create " + customMetadataName + " metadata due to internal dataweave transformation script errors: " + System.lineSeparator() + error));
            });
            return true;
        }
        return false;
    }

    @Override
    public String getMatchingExistingMetadataLocation(String customMetadataName, String locationKey) {
        return "";
    }
}

