/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.HashMap;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.custom.metadata.assistant.IMetadataResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.ResultHandlerParameters;

public class RamlResultHandler
implements IMetadataResultHandler {
    private ITypesManager typesManager;
    private String originDocId;

    public RamlResultHandler(ITypesManager typesManager, String originDocId) {
        this.typesManager = typesManager;
        this.originDocId = originDocId;
    }

    @Override
    public void generateCustomMetadata(ResultHandlerParameters parameters) {
        this.addType(this.typesManager, parameters.getCustomMetadataName(), this.generateRAMLAsCustomMetadata(parameters.getMetadata(), parameters.getMetadataTypeFormat(), parameters.getExistingMetadataName()));
    }

    private MetadataType generateRAMLAsCustomMetadata(MetadataType metadata, MetadataTypeFormat metadataTypeFormat, String existingMetadataName) {
        HashMap<Class, CustomTypeAnnotation> annotations = new HashMap<Class, CustomTypeAnnotation>();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeFormat));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.RAML));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(this.getMatchingExistingMetadataContentByMetadataName(existingMetadataName)));
        annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(this.originDocId));
        return MetadataTypeProxy.proxying((MetadataType)metadata, annotations);
    }

    private String getMatchingExistingMetadataContentByMetadataName(String existingMetadataName) {
        return this.typesManager.findCustomMetadataContentByMetadataName(existingMetadataName);
    }

    @Override
    public String getMatchingExistingMetadataLocation(String customMetadataName, String locationKey) {
        return "";
    }
}

